/*
 * Decompiled with CFR 0.152.
 */
package adams.data.id;

import adams.core.io.FileUtils;
import adams.data.id.AbstractIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIDFilenameGenerator<T>
extends AbstractIDGenerator<T> {
    private static final long serialVersionUID = 5141285178186856446L;
    protected boolean m_MakeFilename;
    protected String m_FilenameReplaceChar;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filename", "makeFilename", false);
        this.m_OptionManager.add("filename-replace", "filenameReplaceChar", "");
    }

    public void setMakeFilename(boolean value) {
        this.m_MakeFilename = value;
        this.reset();
    }

    public boolean getMakeFilename() {
        return this.m_MakeFilename;
    }

    public String makeFilenameTipText() {
        return "If set to true, all characters that cannot appear in a filename are replaced with underscores '_'.";
    }

    public void setFilenameReplaceChar(String value) {
        this.m_FilenameReplaceChar = value;
        this.reset();
    }

    public String getFilenameReplaceChar() {
        return this.m_FilenameReplaceChar;
    }

    public String filenameReplaceCharTipText() {
        return "The character for replacing invalid characters in IDs that are used for filenames; use empty string for removing the invalid characters.";
    }

    @Override
    protected String postProcess(String id) {
        String result = id;
        if (this.m_MakeFilename) {
            result = FileUtils.createFilename(result, this.m_FilenameReplaceChar);
        }
        return result;
    }
}

