/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.Tee;
import adams.flow.core.Token;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Once
extends Tee {
    private static final long serialVersionUID = 6101027874139099046L;
    public static final String BACKUP_EXECUTEDONCE = "executed once";
    protected boolean m_ExecutedOnce;

    @Override
    public String globalInfo() {
        return "Tees off a token only once to the tee actor.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_ExecutedOnce = false;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_EXECUTEDONCE);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_EXECUTEDONCE, this.m_ExecutedOnce);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_EXECUTEDONCE)) {
            this.m_ExecutedOnce = (Boolean)state.get(BACKUP_EXECUTEDONCE);
            state.remove(BACKUP_EXECUTEDONCE);
        }
        super.restoreState(state);
    }

    @Override
    protected boolean canProcessInput(Token token) {
        return !this.m_ExecutedOnce;
    }

    @Override
    protected String processInput(Token token) {
        String result = super.processInput(token);
        this.m_ExecutedOnce = true;
        return result;
    }
}

