/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.flow.core.AdditionalOptionsHandlerUtils;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalOptions
extends Hashtable<String, String> {
    private static final long serialVersionUID = -2378624659828475769L;

    public AdditionalOptions() {
    }

    public AdditionalOptions(String optStr) {
        this();
        try {
            this.putAll(AdditionalOptionsHandlerUtils.breakUpOptions(optStr));
        }
        catch (Exception e) {
            System.err.println("Failed to fill AdditionalOptions object with options from: " + optStr);
            e.printStackTrace();
        }
    }

    public void putBoolean(String key, Boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public void putInteger(String key, Integer value) {
        this.put(key, Integer.toString(value));
    }

    public void putDouble(String key, Double value) {
        this.put(key, Double.toString(value));
    }

    public void putString(String key, String value) {
        this.put(key, value);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defValue) {
        Boolean result = defValue;
        try {
            if (this.containsKey(key)) {
                result = Boolean.parseBoolean((String)this.get(key));
            }
        }
        catch (Exception e) {
            result = defValue;
        }
        return result;
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer defValue) {
        Integer result = defValue;
        try {
            if (this.containsKey(key)) {
                result = Integer.parseInt((String)this.get(key));
            }
        }
        catch (Exception e) {
            result = defValue;
        }
        return result;
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double defValue) {
        Double result = defValue;
        try {
            if (this.containsKey(key)) {
                result = Double.parseDouble((String)this.get(key));
            }
        }
        catch (Exception e) {
            result = defValue;
        }
        return result;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defValue) {
        if (this.containsKey(key)) {
            return (String)this.get(key);
        }
        return defValue;
    }
}

