/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.OptionUtils;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.ModifyingProcessor;

public class MultiProcessor
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = 916259679452752997L;
    protected AbstractActorProcessor[] m_Processors;

    public String globalInfo() {
        return "A meta-processor that processes the actor sequentially with all sub-processors.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("processor", "subProcessors", new AbstractActorProcessor[0]);
    }

    public void setSubProcessors(AbstractActorProcessor[] value) {
        if (value != null) {
            this.m_Processors = value;
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": processors cannot be null!");
        }
    }

    public AbstractActorProcessor[] getSubProcessors() {
        return this.m_Processors;
    }

    public String subProcessorsTipText() {
        return "The array of processors to use.";
    }

    protected void processActor(AbstractActor actor) {
        AbstractActor input = actor;
        AbstractActor output = actor;
        for (int i = 0; i < this.m_Processors.length; ++i) {
            ModifyingProcessor modifying;
            this.debug("Processor " + (i + 1) + "/" + this.m_Processors.length + ": " + OptionUtils.getCommandLine(this.m_Processors[i]));
            AbstractActorProcessor processor = this.m_Processors[i];
            processor.process(input);
            output = null;
            if (processor instanceof ModifyingProcessor && (modifying = (ModifyingProcessor)((Object)processor)).isModified()) {
                output = modifying.getModifiedActor();
                this.m_Modified = true;
            }
            if (output == null) continue;
            input = output;
        }
        this.debug("Finished!");
    }
}

