/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.option.AbstractOptionProducer;
import adams.core.option.FileBasedProducer;
import adams.core.option.NestedProducer;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.AbstractApprovalDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExportDialog
extends AbstractApprovalDialog {
    private static final long serialVersionUID = 201725070566669323L;
    protected GenericObjectEditorPanel m_PanelGOE;
    protected FileChooserPanel m_PanelFile;

    public ExportDialog(Dialog owner) {
        super(owner);
    }

    public ExportDialog(Dialog owner, Dialog.ModalityType modality) {
        super(owner, modality);
    }

    public ExportDialog(Frame owner) {
        super(owner);
    }

    public ExportDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    protected void initGUI() {
        super.initGUI();
        this.setTitle("Export flow");
        ParameterPanel params = new ParameterPanel();
        this.getContentPane().add((Component)params, "Center");
        this.m_PanelGOE = new GenericObjectEditorPanel(AbstractOptionProducer.class, new NestedProducer(), true);
        this.m_PanelGOE.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ExportDialog.this.updateFileChooser();
            }
        });
        params.addParameter("For_mat", (Component)this.m_PanelGOE);
        this.m_PanelFile = new FileChooserPanel();
        this.m_PanelFile.setPromptOverwriteFile(true);
        this.m_PanelFile.setUseSaveDialog(true);
        params.addParameter("_File", (Component)this.m_PanelFile);
        this.pack();
    }

    protected void updateFileChooser() {
        this.m_PanelFile.setDefaultExtension(null);
        this.m_PanelFile.removeChoosableFileFilters();
        this.m_PanelFile.setAcceptAllFileFilterUsed(true);
        this.m_PanelFile.setAutoAppendExtension(false);
        if (this.m_PanelGOE.getCurrent() instanceof FileBasedProducer) {
            FileBasedProducer producer = (FileBasedProducer)this.m_PanelGOE.getCurrent();
            ExtensionFileFilter filter = new ExtensionFileFilter(producer.getFileFormat(), producer.getFileExtensions());
            this.m_PanelFile.setDefaultExtension(producer.getDefaultFileExtension());
            this.m_PanelFile.setAutoAppendExtension(true);
            this.m_PanelFile.addChoosableFileFilter(filter);
            this.m_PanelFile.setFileFilter(filter);
        }
    }

    public void setProducer(AbstractOptionProducer value) {
        if (value == null) {
            value = new NestedProducer();
        }
        this.m_PanelGOE.setCurrent(value);
    }

    public AbstractOptionProducer getProducer() {
        return (AbstractOptionProducer)this.m_PanelGOE.getCurrent();
    }

    public void setFile(File value) {
        this.m_PanelFile.setCurrent(value);
    }

    public File getFile() {
        return (File)this.m_PanelFile.getCurrent();
    }
}

