/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.NamedSetup;
import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.MouseUtils;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.tools.NamedSetupManagementPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NamedSetupEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected SortableAndSearchableTable m_Table;
    protected NamedSetupManagementPanel.Model m_Model;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonClose;

    public static String toString(AbstractOption option, Object object) {
        return ((NamedSetup)object).getName();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new NamedSetup(str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return NamedSetupEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return NamedSetupEditor.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        NamedSetup setup = (NamedSetup)this.getValue();
        String result = setup == null ? "null" : "new " + NamedSetup.class.getName() + "(\"" + Utils.backQuoteChars(setup.getName()) + "\")";
        return result;
    }

    protected JComponent createCustomEditor() {
        JPanel panel = new JPanel(new BorderLayout());
        this.m_Model = new NamedSetupManagementPanel.Model();
        this.m_Table = new SortableAndSearchableTable(this.m_Model);
        this.m_Table.getSelectionModel().setSelectionMode(0);
        this.m_Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                NamedSetupEditor.this.m_ButtonOK.setEnabled(NamedSetupEditor.this.m_Table.getSelectedRowCount() == 1);
            }
        });
        this.m_Table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (NamedSetupEditor.this.m_Table.getSelectedRow() != -1 && MouseUtils.isDoubleClick(e)) {
                    NamedSetupEditor.this.m_ButtonOK.doClick();
                }
            }
        });
        panel.add((Component)new BaseScrollPane(this.m_Table), "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panel.add((Component)panelButtons, "South");
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (NamedSetupEditor.this.m_Table.getSelectedRowCount() == 1) {
                    NamedSetup setup = new NamedSetup((String)NamedSetupEditor.this.m_Table.getValueAt(NamedSetupEditor.this.m_Table.getSelectedRow(), 0));
                    if (!NamedSetupEditor.this.getValue().equals(setup)) {
                        NamedSetupEditor.this.setValue(setup);
                    }
                }
                NamedSetupEditor.this.closeDialog();
            }
        });
        panelButtons.add(this.m_ButtonOK);
        this.m_ButtonClose = new JButton("Cancel");
        this.m_ButtonClose.setMnemonic('C');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NamedSetupEditor.this.closeDialog();
            }
        });
        panelButtons.add(this.m_ButtonClose);
        return panel;
    }

    protected void initForDisplay() {
        int index = this.m_Model.indexOf((NamedSetup)this.getValue());
        this.m_Table.clearSelection();
        if (index != -1) {
            this.m_Table.getSelectionModel().addSelectionInterval(this.m_Table.getDisplayRow(index), this.m_Table.getDisplayRow(index));
        }
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = ((NamedSetup)this.getValue()).getName();
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }
}

