/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.actorpathtree;

import adams.gui.core.dotnotationtree.DotNotationTree;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.goe.actorpathtree.ActorPathNode;
import adams.gui.goe.actorpathtree.ActorPathTreeRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActorPathTree<T extends ActorPathNode>
extends DotNotationTree<T> {
    private static final long serialVersionUID = 6343911349519910301L;
    protected Tree m_FlowTree;

    public ActorPathTree() {
        this.setSorted(true);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FlowTree = null;
    }

    public void setTree(Tree value) {
        this.m_FlowTree = value;
    }

    public Tree getFlow() {
        return this.m_FlowTree;
    }

    @Override
    protected TreeCellRenderer getDefaultRenderer() {
        return new ActorPathTreeRenderer();
    }

    protected String maskEscapedDots(String s) {
        return s.replace("\\.", "\t");
    }

    protected String unmaskEscapedDots(String s) {
        return s.replace("\t", "\\.");
    }

    @Override
    public void setItems(List<String> items) {
        ArrayList<String> masked = new ArrayList<String>();
        for (String item : items) {
            masked.add(this.maskEscapedDots(item));
        }
        super.setItems(masked);
    }

    @Override
    public boolean hasItem(String item) {
        return super.hasItem(this.maskEscapedDots(item));
    }

    @Override
    public void addItem(String item) {
        super.addItem(this.maskEscapedDots(item));
    }

    @Override
    public String getFirstItem() {
        return this.unmaskEscapedDots(super.getFirstItem());
    }

    @Override
    public void setSelectedItem(String item) {
        super.setSelectedItem(this.maskEscapedDots(item));
    }

    @Override
    protected String getRootNodeLabel() {
        return null;
    }

    protected abstract T newNodeInstance(String var1);

    @Override
    protected T newNode(String label) {
        Node node;
        String classname = null;
        if (this.m_FlowTree != null && (node = this.m_FlowTree.locate(label)) != null) {
            classname = node.getActor().getClass().getName();
        }
        T result = this.newNodeInstance(label);
        ((ActorPathNode)result).setClassname(classname);
        return result;
    }

    @Override
    protected void postAddLeaf(T node, String item) {
        String classname = null;
        if (this.m_FlowTree != null) {
            Node located = this.m_FlowTree.locate(item);
            if (located != null) {
                classname = located.getActor().getClass().getName();
            }
            ((ActorPathNode)node).setClassname(classname);
        }
        super.postAddLeaf(node, item);
    }
}

