/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.gui.scripting.AbstractScriptlet;

public class DeleteData
extends AbstractScriptlet {
    private static final long serialVersionUID = 1714520838655609203L;
    public static final String ACTION = "delete-data";

    public String getAction() {
        return ACTION;
    }

    protected String getOptionsDescription() {
        return "<comma-separated list of DB-IDs>";
    }

    public String getDescription() {
        return "Deletes the record with the specified DB-IDs from the database.";
    }

    public String process(String options) throws Exception {
        String[] ids = options.replaceAll(" ", "").split(",");
        for (int i = 0; i < ids.length; ++i) {
            this.showStatus("Deleting record " + (i + 1) + "/" + ids.length + ": " + ids[i]);
            boolean result = this.m_DataProvider.remove(new Integer(ids[i]));
            if (result) continue;
            this.getSystemErr().println("Error deleting record #" + ids[i]);
        }
        this.showStatus("");
        return null;
    }
}

