/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.core.option.AbstractOption;
import adams.core.option.OptionUtils;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.FieldType;
import adams.data.report.FieldUtils;
import adams.gui.core.BasePanel;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFieldPanel
extends BasePanel {
    private static final long serialVersionUID = -3858687917199734023L;
    protected ParameterPanel m_Panel;
    protected JTextField m_TextFields;
    protected JComboBox m_ComboBoxDataType;
    protected FieldType m_FieldType;
    protected boolean m_MultipleSelection;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FieldType = FieldType.FIELD;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Panel = new ParameterPanel();
        this.add((Component)this.m_Panel, "Center");
        this.m_TextFields = new JTextField(15);
        this.m_Panel.addParameter("Field _name", this.m_TextFields);
        this.m_ComboBoxDataType = new JComboBox();
        for (DataType type : DataType.values()) {
            this.m_ComboBoxDataType.addItem(type.toDisplay());
            if (type != DataType.NUMERIC) continue;
            this.m_ComboBoxDataType.setSelectedIndex(this.m_ComboBoxDataType.getModel().getSize() - 1);
        }
        this.m_Panel.addParameter("Data _type", this.m_ComboBoxDataType);
        this.setMultipleSelection(this.isMultipleSelection());
    }

    public void setFieldType(FieldType value) {
        this.m_FieldType = value;
    }

    public FieldType getFieldType() {
        return this.m_FieldType;
    }

    protected void processMissing(Vector<Field> missing) {
        if (this.isMultipleSelection()) {
            String[] list = new String[missing.size()];
            for (int i = 0; i < missing.size(); ++i) {
                list[i] = missing.get(i).toString();
            }
            this.m_TextFields.setText(OptionUtils.joinOptions(list));
        } else {
            this.m_TextFields.setText(missing.get(0).toString());
        }
    }

    public void setDataType(DataType value) {
        this.m_ComboBoxDataType.setSelectedItem(value.toDisplay());
    }

    public DataType getDataType() {
        if (this.m_FieldType == FieldType.PREFIX_FIELD) {
            return null;
        }
        if (this.m_ComboBoxDataType.getSelectedIndex() < 0) {
            return null;
        }
        return DataType.valueOf((AbstractOption)null, (String)this.m_ComboBoxDataType.getSelectedItem());
    }

    protected AbstractField[] getCurrentItems() {
        AbstractField[] result;
        if (this.m_TextFields.getText().length() > 0) {
            try {
                String[] fields = this.isMultipleSelection() ? OptionUtils.splitOptions(this.m_TextFields.getText()) : new String[]{this.m_TextFields.getText()};
                result = new Field[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    result[i] = new Field(fields[i], this.getDataType());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        } else {
            result = new Field[]{};
        }
        return result;
    }

    public AbstractField[] getItems() {
        return FieldUtils.fixClass(this.m_FieldType, this.getCurrentItems());
    }

    public AbstractField getItem() {
        if (this.getItems().length == 0) {
            return null;
        }
        return this.getItems()[0];
    }

    public void setItem(AbstractField value) {
        AbstractField[] items = value != null ? new AbstractField[]{value} : new AbstractField[]{};
        this.setItems(items);
    }

    public void setItems(AbstractField[] value) {
        StringBuilder builder = new StringBuilder();
        DataType dtype = DataType.NUMERIC;
        for (int i = 0; i < value.length; ++i) {
            if (i == 0) {
                dtype = value[i].getDataType();
            } else if (dtype != value[i].getDataType()) {
                dtype = null;
            }
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(value[i].toString());
        }
        if (dtype != null) {
            this.setDataType(dtype);
        }
        this.m_TextFields.setText(builder.toString());
    }

    public void setMultipleSelection(boolean value) {
        this.m_MultipleSelection = value;
    }

    public boolean isMultipleSelection() {
        return this.m_MultipleSelection;
    }

    @Override
    public void grabFocus() {
        this.m_TextFields.grabFocus();
    }
}

