/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.SystemInfo;
import adams.core.io.CsvSpreadSheetWriter;
import adams.core.io.PlaceholderFile;
import adams.core.io.SpreadSheet;
import adams.core.management.JConsole;
import adams.core.management.JMap;
import adams.core.management.JVisualVM;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.HashtableTableModel;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.MouseUtils;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.dialog.TextDialog;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingWorker;

public class SystemInfoPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = 5962605234258828474L;
    protected HashtableTableModel m_TableModel;
    protected SortableAndSearchableTable m_Table;
    protected SearchPanel m_PanelSearch;
    protected SystemInfo m_SystemInfo;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemEditCopy;
    protected JMenuItem m_MenuItemEditSelectAll;
    protected BaseFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_SystemInfo = new SystemInfo();
        this.m_FileChooser = new BaseFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter("CSV files", "csv");
        this.m_FileChooser.addChoosableFileFilter(filter);
        this.m_FileChooser.setFileFilter(filter);
        this.m_FileChooser.setAutoAppendExtension(true);
        this.m_FileChooser.setDefaultExtension("csv");
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TableModel = new HashtableTableModel(this.m_SystemInfo.getInfo());
        this.m_Table = new SortableAndSearchableTable(this.m_TableModel);
        this.m_Table.setAutoResizeMode(3);
        this.add((Component)new BaseScrollPane(this.m_Table), "Center");
        this.m_Table.setOptimalColumnWidth(0);
        this.m_Table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    JPopupMenu menu = SystemInfoPanel.this.getPopupMenu(SystemInfoPanel.this.m_Table.rowAtPoint(e.getPoint()));
                    if (menu == null) {
                        return;
                    }
                    e.consume();
                    menu.show(SystemInfoPanel.this.m_Table, e.getX(), e.getY());
                }
                if (!e.isConsumed()) {
                    super.mouseClicked(e);
                }
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add((Component)panel, "South");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true, "_Search", "_Go");
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                SystemInfoPanel.this.m_Table.search(SystemInfoPanel.this.m_PanelSearch.getSearchText(), SystemInfoPanel.this.m_PanelSearch.isRegularExpression());
                SystemInfoPanel.this.m_PanelSearch.grabFocus();
            }
        });
        panel.add(this.m_PanelSearch);
    }

    protected JPopupMenu getPopupMenu(int row) {
        JPopupMenu result = null;
        if (row > -1) {
            String field = this.m_Table.getValueAt(row, 0).toString();
            String valueStr = this.m_Table.getValueAt(row, 1).toString();
            if (field.equals("java.vm.pid")) {
                final int pid = Integer.parseInt(valueStr);
                if (result == null) {
                    result = new JPopupMenu();
                }
                JMenuItem menuitem = new JMenuItem("Run jmap");
                menuitem.setEnabled(JMap.isAvailable());
                menuitem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SystemInfoPanel.this.runJMap(pid);
                    }
                });
                result.add(menuitem);
                menuitem = new JMenuItem("Start up jvisualvm");
                menuitem.setEnabled(JVisualVM.isAvailable());
                menuitem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SystemInfoPanel.this.runJVisualVM(pid);
                    }
                });
                result.add(menuitem);
                menuitem = new JMenuItem("Start up jconsole");
                menuitem.setEnabled(JConsole.isAvailable());
                menuitem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SystemInfoPanel.this.runJConsole(pid);
                    }
                });
                result.add(menuitem);
            }
        }
        return result;
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            menu.setMnemonic('F');
            result.add(menu);
            JMenuItem menuitem = new JMenuItem("Save as...");
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed S"));
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SystemInfoPanel.this.saveAs();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileSaveAs = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close", GUIHelper.getIcon("exit.png"));
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SystemInfoPanel.this.closeParent();
                }
            });
            menu.add(menuitem);
            menu = new JMenu("Edit");
            menu.setMnemonic('E');
            result.add(menu);
            menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed C"));
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SystemInfoPanel.this.m_Table.copyToClipboard();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemEditCopy = menuitem;
            menuitem = new JMenuItem("Select all", GUIHelper.getEmptyIcon());
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed A"));
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SystemInfoPanel.this.m_Table.selectAll();
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            this.m_MenuItemEditSelectAll = menuitem;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void runJMap(int pid) {
        String options = JOptionPane.showInputDialog(this, "Enter the options for jmap:", JMap.getDefaultOptions());
        if (options == null) {
            return;
        }
        final int fPid = pid;
        final String fOptions = options;
        SwingWorker worker = new SwingWorker(){
            protected String m_Output = null;

            protected Object doInBackground() throws Exception {
                this.m_Output = JMap.execute(fOptions, fPid);
                return null;
            }

            protected void done() {
                TextDialog dialog = new TextDialog();
                dialog.setTitle("jmap (" + fPid + ")");
                dialog.setContent(this.m_Output);
                dialog.setLocationRelativeTo(SystemInfoPanel.this);
                dialog.setVisible(true);
                super.done();
            }
        };
        worker.execute();
    }

    protected void runJVisualVM(int pid) {
        String options = JOptionPane.showInputDialog(this, "Enter the options for jvisualvm:", JVisualVM.getDefaultOptions());
        if (options == null) {
            return;
        }
        final int fPid = pid;
        final String fOptions = options;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JVisualVM.execute(fOptions, fPid);
            }
        });
        thread.start();
    }

    protected void runJConsole(int pid) {
        String options = JOptionPane.showInputDialog(this, "Enter the options for jconsole:", JConsole.getDefaultOptions());
        if (options == null) {
            return;
        }
        final int fPid = pid;
        final String fOptions = options;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JConsole.execute(fOptions, fPid);
            }
        });
        thread.start();
    }

    public SpreadSheet getContent() {
        int i;
        SpreadSheet result = new SpreadSheet();
        for (i = 0; i < 2; ++i) {
            result.getHeaderRow().addCell(this.m_TableModel.getColumnName(i)).setContent(this.m_TableModel.getColumnName(i));
        }
        for (int n = 0; n < this.m_TableModel.getRowCount(); ++n) {
            SpreadSheet.Row row = result.addRow("" + result.getRowCount());
            for (i = 0; i < 2; ++i) {
                row.addCell(this.m_TableModel.getColumnName(i)).setContent("" + this.m_TableModel.getValueAt(n, i));
            }
        }
        return result;
    }

    protected void saveAs() {
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
        SpreadSheet sheet = this.getContent();
        if (!writer.write(sheet, this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage(this, "Failed to write data to file:\n" + this.m_FileChooser.getSelectedFile());
        }
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JTable.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JTable.class}, cls);
    }

    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            result = SendToActionUtils.nextTmpFile("systeminfo", "csv");
            CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
            if (!writer.write(this.getContent(), (File)result)) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, cls)) {
            result = this.m_Table;
        }
        return result;
    }
}

