/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoDataToPreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;

public abstract class AbstractSpreadSheetHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = 460332838835780629L;
    public static final String UNNAMED_SHEET_PREFIX = "Sheet";

    public String globalInfo() {
        return "Displays the following spreadsheet types: " + Utils.arrayToString(this.getExtensions());
    }

    protected abstract SpreadSheet[] readAll(File var1);

    protected JPanel createPreview(File file) {
        BasePanel result;
        SpreadSheet[] sheets = this.readAll(file);
        if (sheets.length > 1) {
            result = new BasePanel(new BorderLayout());
            BaseTabbedPane tabbedPane = new BaseTabbedPane();
            tabbedPane.setTabPlacement(3);
            result.add((Component)tabbedPane, "Center");
            for (int i = 0; i < sheets.length; ++i) {
                if (!sheets[i].hasName()) {
                    sheets[i].setName(UNNAMED_SHEET_PREFIX + (i + 1));
                }
                SpreadSheetTable table = new SpreadSheetTable(sheets[i]);
                tabbedPane.addTab(sheets[i].getName(), new BaseScrollPane(table));
            }
        } else if (sheets.length == 1) {
            result = new BasePanel(new BorderLayout());
            SpreadSheetTable table = new SpreadSheetTable(sheets[0]);
            result.add((Component)new BaseScrollPane(table), "Center");
        } else {
            result = new NoDataToPreviewPanel();
        }
        return result;
    }
}

