/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.axis.Formatter;
import adams.gui.visualization.core.axis.Tick;
import adams.gui.visualization.core.axis.ZoomHandler;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAxisModel
implements Serializable {
    private static final long serialVersionUID = -3950212023344727427L;
    protected AxisPanel m_Parent;
    protected double m_Minimum;
    protected double m_Maximum;
    protected double m_ActualMinimum;
    protected double m_ActualMaximum;
    protected int m_NumTicks;
    protected int m_NthValueToShow;
    protected double m_MarginTop;
    protected double m_MarginBottom;
    protected boolean m_Validated;
    protected Formatter m_Formatter;
    protected Formatter m_CustomerFormatter;
    protected ZoomHandler m_ZoomHandler;
    protected int m_PixelOffset;
    protected Stack<Integer> m_PixelOffsets;

    public AbstractAxisModel() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Parent = null;
        this.m_Minimum = 0.0;
        this.m_Maximum = 1.0;
        this.m_MarginTop = 0.0;
        this.m_MarginBottom = 0.0;
        this.m_PixelOffset = 0;
        this.m_Validated = false;
        this.m_NumTicks = 20;
        this.m_NthValueToShow = 5;
        this.m_Formatter = Formatter.getDecimalFormatter(this.getDefaultNumberFormat());
        this.m_CustomerFormatter = null;
        this.m_ZoomHandler = new ZoomHandler();
        this.m_PixelOffsets = new Stack();
    }

    public void setParent(AxisPanel value) {
        this.m_Parent = value;
    }

    public AxisPanel getParent() {
        return this.m_Parent;
    }

    public abstract String getDisplayName();

    public abstract boolean canHandle(double var1, double var3);

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.invalidate();
        this.update();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.invalidate();
        this.update();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public void setTopMargin(double value) {
        if (value >= 0.0) {
            this.m_MarginTop = value;
            this.invalidate();
            this.update();
        } else {
            System.err.println("Top margin factor must be at least 0.0 (provided: " + value + ")!");
        }
    }

    public double getTopMargin() {
        return this.m_MarginTop;
    }

    public void setBottomMargin(double value) {
        if (value >= 0.0) {
            this.m_MarginBottom = value;
            this.invalidate();
            this.update();
        } else {
            System.err.println("Bottom margin factor must be at least 0.0 (provided: " + value + ")!");
        }
    }

    public double getBottomMargin() {
        return this.m_MarginBottom;
    }

    public void setPixelOffset(int value) {
        this.m_PixelOffset = value;
        this.invalidate();
        this.update();
    }

    public int getPixelOffset() {
        return this.m_PixelOffset;
    }

    public String getDefaultNumberFormat() {
        return "0.00E0;-0.00E0";
    }

    public void setNumberFormat(String value) {
        this.m_Formatter.applyPattern(value);
        this.update();
    }

    public String getNumberFormat() {
        return this.m_Formatter.toPattern();
    }

    public boolean hasCustomFormatter() {
        return this.m_CustomerFormatter != null;
    }

    public void setCustomFormatter(Formatter value) {
        this.m_CustomerFormatter = value;
    }

    public Formatter getCustomFormatter() {
        return this.m_CustomerFormatter;
    }

    protected Formatter getActualFormatter() {
        if (this.hasCustomFormatter()) {
            return this.m_CustomerFormatter;
        }
        return this.m_Formatter;
    }

    public void setNthValueToShow(int value) {
        if (value >= 0) {
            this.m_NthValueToShow = value;
            this.update();
        } else {
            System.err.println("'n-th value to show' must be >=0, provided: " + value);
        }
    }

    public int getNthValueToShow() {
        return this.m_NthValueToShow;
    }

    public void setNumTicks(int value) {
        if (value > 0) {
            this.m_NumTicks = value;
            this.update();
        } else {
            System.err.println("Number of ticks must be >0, provided: " + value);
        }
    }

    public int getNumTicks() {
        return this.m_NumTicks;
    }

    public void pushZoom(double min, double max) {
        this.m_ZoomHandler.push(min, max);
        this.m_PixelOffsets.push(this.m_PixelOffset);
        this.m_PixelOffset = 0;
        this.invalidate();
        this.update();
    }

    public void popZoom() {
        if (this.isZoomed()) {
            this.m_ZoomHandler.pop();
            this.m_PixelOffset = this.m_PixelOffsets.pop();
            this.invalidate();
            this.update();
        }
    }

    public boolean isZoomed() {
        return this.m_ZoomHandler.isZoomed();
    }

    public void clearZoom() {
        if (this.isZoomed()) {
            this.m_ZoomHandler.clear();
            this.m_PixelOffset = 0;
            this.m_PixelOffsets.clear();
            this.invalidate();
            this.update();
        }
    }

    public Vector<Tick> getTicks() {
        Vector<Tick> result = new Vector<Tick>();
        double incValue = (this.m_ActualMaximum - this.m_ActualMinimum) / (double)this.m_NumTicks;
        HashSet<String> labels = new HashSet<String>();
        for (int i = 0; i < this.m_NumTicks + 1; ++i) {
            double value = this.m_ActualMinimum + (double)i * incValue;
            int pos = this.valueToPos(value);
            String label = this.valueToDisplay(this.posToValue(pos));
            if (labels.contains(label)) {
                label = " ";
            }
            if (label.equals("NaN")) {
                label = " ";
            }
            if (this.m_NthValueToShow == 0 || i % this.m_NthValueToShow != 0) {
                label = null;
            }
            result.add(new Tick(pos, label));
            if (label == null) continue;
            labels.add(label);
        }
        return result;
    }

    public abstract String valueToDisplay(double var1);

    public abstract double displayToValue(String var1);

    public abstract int valueToPos(double var1);

    public abstract double posToValue(int var1);

    public void invalidate() {
        this.m_Validated = false;
    }

    public void validate() {
        double max;
        double min;
        if (this.m_Validated) {
            return;
        }
        if (this.m_ZoomHandler.isZoomed()) {
            min = this.m_ZoomHandler.peek().getMinimum();
            max = this.m_ZoomHandler.peek().getMaximum();
        } else {
            min = this.m_Minimum;
            max = this.m_Maximum;
        }
        double size = this.getParent().getLength() == 0 ? 1.0 : (double)this.getParent().getLength();
        double range = Math.abs(max - min);
        double offset = range / size * (double)this.m_PixelOffset;
        this.m_ActualMinimum = min - range * this.m_MarginBottom - offset;
        this.m_ActualMaximum = max + range * this.m_MarginTop - offset;
        this.m_Validated = true;
    }

    public void assign(AbstractAxisModel model) {
        this.m_Parent = model.m_Parent;
        this.m_Minimum = model.m_Minimum;
        this.m_Maximum = model.m_Maximum;
        this.m_MarginTop = model.m_MarginTop;
        this.m_MarginBottom = model.m_MarginBottom;
        this.m_ZoomHandler = model.m_ZoomHandler.getClone();
        this.m_PixelOffsets = (Stack)model.m_PixelOffsets.clone();
        this.m_PixelOffset = model.m_PixelOffset;
        this.m_CustomerFormatter = model.m_CustomerFormatter;
        this.m_NthValueToShow = model.m_NthValueToShow;
        this.m_NumTicks = model.m_NumTicks;
        this.invalidate();
        this.update();
    }

    public void update() {
        this.validate();
        if (this.m_Parent != null) {
            this.m_Parent.repaint();
        }
    }

    public String toString() {
        String result = this.getClass().getName() + ": ";
        result = result + "min=" + this.getMinimum() + ", ";
        result = result + "max=" + this.getMaximum() + ", ";
        result = result + "topMargin=" + this.getTopMargin() + ", ";
        result = result + "bottomMargin=" + this.getBottomMargin() + ", ";
        result = result + "format=" + this.getNumberFormat();
        return result;
    }
}

