/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractAxisModel;

public class PercentageAxisModel
extends AbstractAxisModel {
    private static final long serialVersionUID = 6882846237550109166L;

    public boolean canHandle(double min, double max) {
        return true;
    }

    public String getDisplayName() {
        return "Percent";
    }

    public String getDefaultNumberFormat() {
        return "0.0'%';-0.0'%'";
    }

    public String valueToDisplay(double value) {
        String result;
        if (Double.isNaN(value)) {
            result = this.getActualFormatter().format(value);
        } else {
            double raw = (value - this.m_Minimum) / (this.m_Maximum - this.m_Minimum) * 100.0;
            result = this.getActualFormatter().format(raw);
        }
        return result;
    }

    public double displayToValue(String display) {
        Double result = this.getActualFormatter().parse(display);
        if (!result.isNaN()) {
            result = result / 100.0;
            result = result * (this.m_Maximum - this.m_Minimum);
            result = result + this.m_Minimum;
        }
        return result;
    }

    public int valueToPos(double value) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        int result = (int)Math.round((value - this.m_ActualMinimum) / (this.m_ActualMaximum - this.m_ActualMinimum) * (double)size);
        return result;
    }

    public double posToValue(int pos) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        double result = (double)pos / (double)size * (this.m_ActualMaximum - this.m_ActualMinimum) + this.m_ActualMinimum;
        return result;
    }
}

