/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.menu.AbstractParameterHandlingWekaMenuItemDefinition;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GraphVisualizer
extends AbstractParameterHandlingWekaMenuItemDefinition {
    private static final long serialVersionUID = -771667287275117680L;
    protected JFileChooser m_FileChooser;

    public GraphVisualizer(AbstractApplicationFrame owner) {
        super(owner);
    }

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_FileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("XML BIF file", "xml"));
    }

    public void launch() {
        String filename;
        if (this.m_Parameters.length == 0) {
            int retVal = this.m_FileChooser.showOpenDialog((Component)this.getOwner());
            if (retVal != 0) {
                return;
            }
            filename = this.m_FileChooser.getSelectedFile().getAbsolutePath();
        } else {
            filename = new PlaceholderFile(this.m_Parameters[0]).getAbsolutePath();
        }
        weka.gui.graphvisualizer.GraphVisualizer panel = new weka.gui.graphvisualizer.GraphVisualizer();
        try {
            if (filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".bif")) {
                panel.readBIF((InputStream)new FileInputStream(filename));
            } else {
                panel.readDOT((Reader)new FileReader(filename));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)this.getOwner(), "Error loading file '" + filename + "':\n" + e.getMessage());
            return;
        }
        ChildFrame frame = this.createChildFrame((Component)panel, 800, 600);
        frame.setTitle(frame.getTitle() + " - " + filename);
    }

    public String getTitle() {
        return "GraphVisualizer";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }
}

