/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.weka.ArffUtils;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.CustomSearchTableModel;
import adams.gui.core.SearchParameters;
import weka.core.Attribute;
import weka.core.Instances;

public class InstanceTableModel
extends AbstractBaseTableModel
implements CustomSearchTableModel {
    private static final long serialVersionUID = -1824525024174249640L;
    protected Instances m_Data;

    public InstanceTableModel(Instances data) {
        this.m_Data = data;
    }

    protected Attribute getAttribute(int column) {
        if (this.m_Data != null && column > 0) {
            return this.m_Data.attribute(column - 1);
        }
        return null;
    }

    public Instances getData() {
        return this.m_Data;
    }

    public int getRowCount() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.numInstances();
    }

    public int getColumnCount() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.numAttributes() + 1;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Index";
        }
        return this.m_Data.attribute(column - 1).name();
    }

    public Object getValueAt(int row, int column) {
        Attribute att = this.getAttribute(column);
        if (column == 0) {
            return row + 1;
        }
        if (att == null) {
            return "";
        }
        if (this.m_Data.instance(row).isMissing(att)) {
            return null;
        }
        if (att.name().equals(ArffUtils.getDBIDName())) {
            return (int)this.m_Data.instance(row).value(att);
        }
        if (att.name().equals(ArffUtils.getIDName())) {
            return this.m_Data.instance(row).stringValue(att).replaceAll("'", "");
        }
        switch (att.type()) {
            case 0: {
                return this.m_Data.instance(row).value(att);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.m_Data.instance(row).stringValue(att);
            }
        }
        return "???";
    }

    public Class getColumnClass(int column) {
        Attribute att = this.getAttribute(column);
        if (column == 0) {
            return Integer.class;
        }
        if (att == null) {
            return String.class;
        }
        if (att.name().equals(ArffUtils.getDBIDName())) {
            return Integer.class;
        }
        switch (att.type()) {
            case 0: {
                return Double.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return String.class;
            }
        }
        return String.class;
    }

    public boolean isSearchMatch(SearchParameters params, int row) {
        for (int n = 1; n < this.m_Data.numAttributes(); ++n) {
            String valStr;
            Attribute att = this.m_Data.attribute(n);
            if (!(att.type() == 0 && params.isDouble() ? params.matches(Double.valueOf(this.m_Data.instance(row).value(att))) : params.matches(valStr = att.type() == 0 ? "" + this.m_Data.instance(row).value(att) : this.m_Data.instance(row).stringValue(att)))) continue;
            return true;
        }
        return false;
    }
}

