/*
 * TrainTestSetContainer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.container;

import weka.core.Instances;

import java.util.Enumeration;
import java.util.Vector;

/**
 * A container for storing a single evaluation result
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 628 $
 */
public class ExpDBInformationContainer
  extends AbstractContainer {

  /** for serialization. */
  private static final long serialVersionUID = 7650097276531433711L;

  /** the identifier for the evaluation object. */
  public final static String VALUE_EVALUATION = "Evaluation";

  /** the identifier for the fold number. */
  public final static String VALUE_FOLDNR = "FoldNr";

  /**
   * Initializes the container.
   * <p/>
   * Only used for generating help information.
   */
  public ExpDBInformationContainer() {
    this(null, null);
  }

  /**
   * Initializes the container.
   *
   * @param train	the training set
   * @param test	the test data
   */
  public ExpDBInformationContainer(Instances train, Instances test) {
    super();

    store(VALUE_EVALUATION, train);
    store(VALUE_FOLDNR, test);
  }

  /**
   * Returns all value names that can be used (theoretically).
   *
   * @return		enumeration over all possible value names
   */
  public Enumeration<String> names() {
    Vector<String>	result;

    result = new Vector<String>();

    result.add(VALUE_EVALUATION);
    result.add(VALUE_FOLDNR);

    return result.elements();
  }

  /**
   * Checks whether the setup of the container is valid.
   *
   * @return		true if all the necessary values are available
   */
  public boolean isValid() {
    return hasValue(VALUE_EVALUATION) && hasValue(VALUE_FOLDNR);
  }
}
