/**
 * AbstractPlotScriptlet.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.gnuplot;

/**
 * Ancestor for scriptlets that generate plot instructions.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2876 $
 */
public abstract class AbstractPlotScriptlet
  extends AbstractScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = 8856618164829129380L;

  /** the columns to use. */
  protected String m_Columns;

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "cols", "columns",
	    "1:2");
  }

  /**
   * Sets the columns to use in the plots.
   *
   * @param value	the columns
   */
  public void setColumns(String value) {
    m_Columns = value;
    reset();
  }

  /**
   * Returns the columns to use in the plots.
   *
   * @return		the index
   */
  public String getColumns() {
    return m_Columns;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   *         		displaying in the explorer/experimenter gui
   */
  public String columnsTipText() {
    return "The columns to use in the plot.";
  }
}
