/*
 * Decompiled with CFR 0.152.
 */
package adams.core.gnuplot;

import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandlingObject;

public abstract class AbstractScriptlet
extends OptionHandlingObject {
    private static final long serialVersionUID = 8269710957096517396L;
    public static final String COMMENT = "#";
    protected PlaceholderFile m_DataFile;
    protected String m_LastError;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-file", "dataFile", (Object)new PlaceholderFile("."));
    }

    protected void reset() {
        super.reset();
        this.m_LastError = null;
    }

    public void setDataFile(PlaceholderFile value) {
        this.m_DataFile = value;
        this.reset();
    }

    public PlaceholderFile getDataFile() {
        return this.m_DataFile;
    }

    public String dataFileTipText() {
        return "The data file to use as basis for the plot.";
    }

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    public String check() {
        if (!this.m_DataFile.exists()) {
            return "Data file '" + this.m_DataFile + "' does not exist!";
        }
        if (!this.m_DataFile.isFile()) {
            return "'" + this.m_DataFile + "' is not a file?";
        }
        return null;
    }

    protected abstract String doGenerate();

    public String generate() {
        this.m_LastError = this.check();
        if (this.hasLastError()) {
            return null;
        }
        return this.doGenerate();
    }
}

