/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    Groovy.java
 *    Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.flow.condition.test;

import adams.flow.condition.test.AbstractCondition;
import adams.flow.condition.test.AbstractScriptCondition;
import adams.flow.core.AdditionalOptionsHandler;
import adams.flow.core.AdditionalOptionsHandlerUtils;

/**
 <!-- globalinfo-start -->
 * A condition that uses the condition defined in an external Groovy script.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 * &nbsp;&nbsp;&nbsp;If set to true, scheme may output additional info to the console.
 * </pre>
 *
 * <pre>-script &lt;adams.core.io.PlaceholderFile&gt; (property: scriptFile)
 * &nbsp;&nbsp;&nbsp;The script file to load and execute.
 * &nbsp;&nbsp;&nbsp;default: .
 * </pre>
 *
 * <pre>-options &lt;java.lang.String&gt; (property: scriptOptions)
 * &nbsp;&nbsp;&nbsp;The options for the script.
 * &nbsp;&nbsp;&nbsp;default:
 * </pre>
 *
 <!-- options-end -->
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 * @see adams.core.scripting.Groovy
 */
public class Groovy
  extends AbstractScriptCondition {

  /** for serialization. */
  private static final long serialVersionUID = -5904986133981940404L;

  /** the loaded script object. */
  protected transient AbstractCondition m_ConditionObject;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "A condition that uses the condition defined in an external Groovy script.";
  }

  /**
   * Loads the scripts object and sets its options.
   *
   * @return		null if OK, otherwise the error message
   */
  protected String loadScriptObject() {
    String	result;

    result = null;

    try {
      m_ScriptObject = null;
      if (m_ScriptFile.isFile()) {
	m_ScriptObject = (AbstractCondition) adams.core.scripting.Groovy.newInstance(m_ScriptFile, AbstractCondition.class);
	if (m_ScriptObject != null) {
	  if (!AdditionalOptionsHandlerUtils.setOptions(m_ScriptObject, m_ScriptOptions))
	    result = "Does not implement '" + AdditionalOptionsHandler.class.getName() + "': " + m_ScriptFile;
	}
	else {
	  result = "Failed to instantiate script '" + m_ScriptFile + "'!";
	}
      }
      else {
	result = "No script provided!";
      }
    }
    catch (Exception e) {
      m_ScriptObject = null;
      getSystemErr().printStackTrace(e);
      result = "Failed to initialize Groovy script '" + m_ScriptFile + "': " + e.toString();
    }

    return result;
  }

  /**
   * Checks the script object.
   *
   * @return		always null, i.e., OK
   */
  protected String checkScriptObject() {
    m_ConditionObject = (AbstractCondition) m_ScriptObject;
    return null;
  }

  /**
   * Runs the script test.
   *
   * @return		the test result, null if everything OK, otherwise
   * 			the error message
   */
  protected String performScriptTest() {
    return m_ConditionObject.getTestResult();
  }
}
