/*
 * ImageJ.java
 * Copyright (C) 2010-2011 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.core.GUIHelper;

/**
 * Starts the ImageJ GUI.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 * @see adams.core.management.ImageJ
 */
public class ImageJ
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 5304941130851992514L;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public ImageJ(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "imagej.gif";
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    try {
      ij.ImageJ ij = new ij.ImageJ();
      ij.setLocationRelativeTo(getOwner());
    }
    catch (Exception e) {
      e.printStackTrace();
      GUIHelper.showErrorMessage(
	  getOwner(), "Failed to launch ImageJ frame:\n" + e);
    }
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "ImageJ";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return CATEGORY_VISUALIZATION;
  }
}