/**
 * JAITransformer.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.image.plugins;

import java.awt.Dialog.ModalityType;
import java.awt.image.BufferedImage;

import adams.data.jai.transformer.AbstractJAITransformer;
import adams.data.jai.transformer.PassThrough;
import adams.gui.goe.GenericObjectEditorDialog;

/**
 * Allows the user to apply a JAI transformer to an image in the ImageViewer.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4095 $
 */
public class JAITransformer
  extends AbstractImageFilter {

  /** for serialization. */
  private static final long serialVersionUID = -3146372359577147914L;

  /**
   * Returns the text for the menu item to create.
   *
   * @return		the text
   */
  public String getCaption() {
    return "Apply JAI transformer...";
  }

  /**
   * Filters the image.
   *
   * @param image	the image to filter
   * @return		the processed image
   */
  protected BufferedImage filter(BufferedImage image) {
    BufferedImage		result;
    GenericObjectEditorDialog	dialog;
    AbstractJAITransformer	transformer;
    BufferedImage[]		transformed;

    result = null;
    if (m_CurrentPanel.getParentDialog() != null)
      dialog = new GenericObjectEditorDialog(m_CurrentPanel.getParentDialog());
    else
      dialog = new GenericObjectEditorDialog(m_CurrentPanel.getParentFrame());
    dialog.getGOEEditor().setClassType(AbstractJAITransformer.class);
    dialog.getGOEEditor().setCanChangeClassInDialog(true);
    if (hasLastSetup())
      dialog.setCurrent(getLastSetup());
    else
      dialog.setCurrent(new PassThrough());
    dialog.setModalityType(ModalityType.DOCUMENT_MODAL);
    dialog.setLocationRelativeTo(m_CurrentPanel);
    dialog.setVisible(true);
    if (dialog.getResult() != GenericObjectEditorDialog.APPROVE_OPTION) {
      m_CanceledByUser = true;
      return result;
    }

    setLastSetup(dialog.getCurrent());
    transformer = (AbstractJAITransformer) dialog.getCurrent();
    transformed = transformer.transform(image);
    if (transformed.length == 0)
      m_FilterError = "No filtered image generated!";
    if (transformed.length > 1)
      getSystemErr().println("WARNING: Generated more than one image, using only first one.");
    if (transformed.length >= 1)
      result = transformed[0];

    return result;
  }
}
