/**
 * HistogramTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.jai.flattener;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.data.jai.flattener.Histogram.HistogramType;
import adams.env.Environment;

/**
 * Test class for the Histogram flattener. Run from the command line with: <p/>
 * java adams.data.jai.flattener.HistogramTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3707 $
 */
public class HistogramTest
  extends AbstractJAIFlattenerTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public HistogramTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"adams_logo.png",
	"adams_logo.png"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractJAIFlattener[] getRegressionSetups() {
    Histogram[]	result;

    result = new Histogram[2];

    result[0] = new Histogram();
    result[0].setHistogramType(HistogramType.RGB);

    result[1] = new Histogram();
    result[1].setHistogramType(HistogramType.EIGHT_BIT);

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(HistogramTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
