/*
 * ImageMagickTransformerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import adams.env.Environment;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import junit.framework.Test;
import junit.framework.TestSuite;
import adams.flow.core.AbstractActor;
import adams.flow.control.Flow;
import adams.flow.AbstractFlowTest;

/**
 * Test for ImageMagickTransformer actor.
 *
 * @author fracpete
 * @author adams.core.option.FlowJUnitTestProducer (code generator)
 * @version $Revision: 3297 $
 */
public class ImageMagickTransformerTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ImageMagickTransformerTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception 	if an error occurs.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("adams_logo.png");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("adams_logo.png");

    super.tearDown();
  }

  /**
   *
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(ImageMagickTransformerTest.class);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    AbstractArgumentOption    argOption;

    Flow flow = new Flow();

    try {
      argOption = (AbstractArgumentOption) flow.getOptionManager().findByProperty("actors");
      adams.flow.core.AbstractActor[] tmp1 = new adams.flow.core.AbstractActor[4];
      adams.flow.source.SingleFileSupplier tmp2 = new adams.flow.source.SingleFileSupplier();
      argOption = (AbstractArgumentOption) tmp2.getOptionManager().findByProperty("file");
      tmp2.setFile((adams.core.io.PlaceholderFile) argOption.valueOf("${TMP}/adams_logo.png"));

      tmp1[0] = tmp2;
      adams.flow.transformer.ImageMagickReader tmp4 = new adams.flow.transformer.ImageMagickReader();
      tmp1[1] = tmp4;
      adams.flow.transformer.ImageMagickTransformer tmp5 = new adams.flow.transformer.ImageMagickTransformer();
      argOption = (AbstractArgumentOption) tmp5.getOptionManager().findByProperty("commands");
      tmp5.setCommands((adams.core.base.BaseText) argOption.valueOf("# resizing image\n-resize 90x90 \n\n# scaling it up again\n-scale 200%"));

      tmp1[2] = tmp5;
      adams.flow.sink.ImageViewer tmp7 = new adams.flow.sink.ImageViewer();
      argOption = (AbstractArgumentOption) tmp7.getOptionManager().findByProperty("writer");
      adams.gui.print.NullWriter tmp9 = new adams.gui.print.NullWriter();
      tmp7.setWriter(tmp9);

      tmp1[3] = tmp7;
      flow.setActors(tmp1);

    }
    catch (Exception e) {
      fail("Failed to set up actor: " + e);
    }

    return flow;
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(adams.env.Environment.class);
    runTest(suite());
  }
}

