/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * JAIHelper.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core;

import java.io.File;

import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

/**
 * Helper class for JAI operations.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class JAIHelper {

  /**
   * Disables the "java.lang.NoClassDefFoundError: com/sun/medialib/mlib/Image"
   * exception.
   * <p/>
   * Taken from <a href="http://www.java.net/node/666373" target="_blank">here</a>
   */
  public static void disableMediaLib() {
    System.setProperty("com.sun.media.jai.disableMediaLib", "true");
  }

  /**
   * Loads the specified file.
   *
   * @param file	the file to load
   * @return		the image
   */
  public static RenderedOp read(File file) {
    return read(file.getAbsolutePath());
  }

  /**
   * Loads the specified file.
   *
   * @param file	the file to load
   * @return		the image
   */
  public static RenderedOp read(String file) {
    RenderedOp	result;

    result =  JAI.create("fileload", file);

    return result;
  }
}
