/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MovieWriterTest.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.sink;

import adams.env.Environment;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import junit.framework.Test;
import junit.framework.TestSuite;
import adams.flow.core.AbstractActor;
import adams.flow.control.Flow;
import adams.flow.AbstractFlowTest;

/**
 * Test for MovieWriter actor.
 *
 * @author fracpete
 * @author adams.core.option.FlowJUnitTestProducer (code generator)
 * @version $Revision: 4584 $
 */
public class MovieWriterTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public MovieWriterTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception 	if an error occurs.
   */
  protected void setUp() throws Exception {
    super.setUp();
    
    m_TestHelper.copyResourceToTmp("mandel-00001.jpg");
    m_TestHelper.copyResourceToTmp("mandel-00002.jpg");
    m_TestHelper.copyResourceToTmp("mandel-00003.jpg");
    m_TestHelper.copyResourceToTmp("mandel-00004.jpg");
    m_TestHelper.copyResourceToTmp("mandel-00005.jpg");
    m_TestHelper.deleteFileFromTmp("mandelbrot.mov");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("mandel-00001.jpg");
    m_TestHelper.deleteFileFromTmp("mandel-00002.jpg");
    m_TestHelper.deleteFileFromTmp("mandel-00003.jpg");
    m_TestHelper.deleteFileFromTmp("mandel-00004.jpg");
    m_TestHelper.deleteFileFromTmp("mandel-00005.jpg");
    m_TestHelper.deleteFileFromTmp("mandelbrot.mov");
    
    super.tearDown();
  }

  /**
   * 
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(MovieWriterTest.class);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    AbstractArgumentOption    argOption;
    
    Flow flow = new Flow();
    
    try {
      argOption = (AbstractArgumentOption) flow.getOptionManager().findByProperty("actors");
      adams.flow.core.AbstractActor[] tmp1 = new adams.flow.core.AbstractActor[2];
      adams.flow.source.DirectoryLister tmp2 = new adams.flow.source.DirectoryLister();
      tmp2.setOutputArray(true);

      argOption = (AbstractArgumentOption) tmp2.getOptionManager().findByProperty("watchDir");
      tmp2.setWatchDir((adams.core.io.PlaceholderDirectory) argOption.valueOf("${TMP}"));

      tmp2.setListFiles(true);

      argOption = (AbstractArgumentOption) tmp2.getOptionManager().findByProperty("regExp");
      tmp2.setRegExp((adams.core.base.BaseRegExp) argOption.valueOf(".*mandel-.*jpg"));

      argOption = (AbstractArgumentOption) tmp2.getOptionManager().findByProperty("sorting");
      tmp2.setSorting((adams.core.io.DirectoryLister.Sorting) argOption.valueOf("SORT_BY_NAME"));

      tmp1[0] = tmp2;
      adams.flow.sink.MovieWriter tmp6 = new adams.flow.sink.MovieWriter();
      argOption = (AbstractArgumentOption) tmp6.getOptionManager().findByProperty("outputFile");
      tmp6.setOutputFile((adams.core.io.PlaceholderFile) argOption.valueOf("${TMP}/mandelbrot.mov"));

      argOption = (AbstractArgumentOption) tmp6.getOptionManager().findByProperty("width");
      tmp6.setWidth((Integer) argOption.valueOf("358"));

      argOption = (AbstractArgumentOption) tmp6.getOptionManager().findByProperty("height");
      tmp6.setHeight((Integer) argOption.valueOf("171"));

      argOption = (AbstractArgumentOption) tmp6.getOptionManager().findByProperty("frameRate");
      tmp6.setFrameRate((Integer) argOption.valueOf("1"));

      tmp1[1] = tmp6;
      flow.setActors(tmp1);

    }
    catch (Exception e) {
      fail("Failed to set up actor: " + e);
    }
    
    return flow;
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(adams.env.Environment.class);
    runTest(suite());
  }
}

