/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.MovieWriter;
import adams.flow.source.DirectoryLister;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MovieWriterTest
extends AbstractFlowTest {
    public MovieWriterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("mandel-00001.jpg");
        this.m_TestHelper.copyResourceToTmp("mandel-00002.jpg");
        this.m_TestHelper.copyResourceToTmp("mandel-00003.jpg");
        this.m_TestHelper.copyResourceToTmp("mandel-00004.jpg");
        this.m_TestHelper.copyResourceToTmp("mandel-00005.jpg");
        this.m_TestHelper.deleteFileFromTmp("mandelbrot.mov");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("mandel-00001.jpg");
        this.m_TestHelper.deleteFileFromTmp("mandel-00002.jpg");
        this.m_TestHelper.deleteFileFromTmp("mandel-00003.jpg");
        this.m_TestHelper.deleteFileFromTmp("mandel-00004.jpg");
        this.m_TestHelper.deleteFileFromTmp("mandel-00005.jpg");
        this.m_TestHelper.deleteFileFromTmp("mandelbrot.mov");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(MovieWriterTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[2];
            DirectoryLister tmp2 = new DirectoryLister();
            tmp2.setOutputArray(true);
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("watchDir");
            tmp2.setWatchDir((PlaceholderDirectory)argOption.valueOf("${TMP}"));
            tmp2.setListFiles(true);
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("regExp");
            tmp2.setRegExp((BaseRegExp)argOption.valueOf(".*mandel-.*jpg"));
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("sorting");
            tmp2.setSorting((DirectoryLister.Sorting)argOption.valueOf("SORT_BY_NAME"));
            tmp1[0] = tmp2;
            MovieWriter tmp6 = new MovieWriter();
            argOption = (AbstractArgumentOption)tmp6.getOptionManager().findByProperty("outputFile");
            tmp6.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/mandelbrot.mov"));
            argOption = (AbstractArgumentOption)tmp6.getOptionManager().findByProperty("width");
            tmp6.setWidth(((Integer)argOption.valueOf("358")).intValue());
            argOption = (AbstractArgumentOption)tmp6.getOptionManager().findByProperty("height");
            tmp6.setHeight(((Integer)argOption.valueOf("171")).intValue());
            argOption = (AbstractArgumentOption)tmp6.getOptionManager().findByProperty("frameRate");
            tmp6.setFrameRate(((Integer)argOption.valueOf("1")).intValue());
            tmp1[1] = tmp6;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            MovieWriterTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MovieWriterTest.runTest((Test)MovieWriterTest.suite());
    }
}

