/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.flattener;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.base.BaseString;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.data.imagej.Image;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public abstract class AbstractImageJFlattener
extends OptionHandlingObject
implements Comparable,
CleanUpHandler {
    private static final long serialVersionUID = 4566948525813804085L;
    public static final String METADATA_PREFIX = "metadata-";
    protected BaseString[] m_MetaDataNumeric;
    protected BaseString[] m_MetaDataString;
    protected Instances m_Header;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("meta-numeric", "metaDataNumeric", (Object)new BaseString[0]);
        this.m_OptionManager.add("meta-string", "metaDataString", (Object)new BaseString[0]);
    }

    protected void reset() {
        super.reset();
        this.m_Header = null;
    }

    public void setMetaDataNumeric(BaseString[] value) {
        this.m_MetaDataNumeric = value;
        this.reset();
    }

    public BaseString[] getMetaDataNumeric() {
        return this.m_MetaDataNumeric;
    }

    public String metaDataNumericTipText() {
        return "The keys of the meta-data properties that will be converted to numeric attributes.";
    }

    public void setMetaDataString(BaseString[] value) {
        this.m_MetaDataString = value;
        this.reset();
    }

    public BaseString[] getMetaDataString() {
        return this.m_MetaDataString;
    }

    public String metaDataStringTipText() {
        return "The keys of the meta-data properties that will be converted to string attributes.";
    }

    protected void checkImage(Image img) {
        if (img == null) {
            throw new IllegalStateException("No image provided!");
        }
    }

    protected abstract Instances createHeader(Image var1);

    protected Instances createMetaDataHeader(Instances header, boolean numeric) {
        Instances result = header;
        BaseString[] keys = numeric ? this.m_MetaDataNumeric : this.m_MetaDataString;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i].toString();
            Add add = new Add();
            add.setAttributeIndex("last");
            add.setAttributeName(METADATA_PREFIX + key);
            if (numeric) {
                add.setAttributeType(new SelectedTag(0, Add.TAGS_TYPE));
            } else {
                add.setAttributeType(new SelectedTag(2, Add.TAGS_TYPE));
            }
            try {
                add.setInputFormat(result);
                result = Filter.useFilter((Instances)result, (Filter)add);
                continue;
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to add " + (numeric ? "numeric" : "string attribute for key '" + key + "':"));
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        return result;
    }

    protected Instances createMetaDataHeader(Instances header) {
        Instances result = header;
        result = this.createMetaDataHeader(result, true);
        result = this.createMetaDataHeader(result, false);
        return result;
    }

    protected abstract Instance doFlatten(Image var1);

    protected Instance addMetaData(Properties meta, Instance inst, boolean numeric) {
        BaseString[] keys = numeric ? this.m_MetaDataNumeric : this.m_MetaDataString;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i].toString();
            Attribute att = this.m_Header.attribute(METADATA_PREFIX + key);
            if (att == null) {
                this.debug("Attribute 'metadata-" + key + "' not found??");
                continue;
            }
            if (meta.hasKey(key)) {
                if (numeric) {
                    try {
                        inst.setValue(att, meta.getDouble(key).doubleValue());
                    }
                    catch (Exception e) {
                        this.getSystemErr().println("Failed to parse double value for meta-data key '" + key + "':");
                        this.getSystemErr().printStackTrace((Throwable)e);
                    }
                    continue;
                }
                inst.setValue(att, meta.getProperty(key));
                continue;
            }
            inst.setMissing(att);
        }
        return inst;
    }

    protected Instance addMetaData(Image img, Instance inst) {
        Properties meta = img.getMetaData();
        inst = this.addMetaData(meta, inst, true);
        inst = this.addMetaData(meta, inst, false);
        return inst;
    }

    public Instance flatten(Image img) {
        this.checkImage(img);
        if (this.m_Header == null) {
            Instances header = this.createHeader(img);
            if (header == null) {
                throw new IllegalStateException("Failed to create header!");
            }
            this.m_Header = this.createMetaDataHeader(header);
        }
        Instance result = this.doFlatten(img);
        result = this.addMetaData(img, result);
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)this).compareTo(OptionUtils.getCommandLine((Object)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public AbstractImageJFlattener shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractImageJFlattener shallowCopy(boolean expand) {
        return (AbstractImageJFlattener)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public void cleanUp() {
        this.reset();
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public static String[] getFlatteners() {
        return ClassLister.getSingleton().getClassnames(AbstractImageJFlattener.class);
    }

    public static AbstractImageJFlattener forName(String classname, String[] options) {
        AbstractImageJFlattener result;
        try {
            result = (AbstractImageJFlattener)OptionUtils.forName(AbstractImageJFlattener.class, (String)classname, (String[])options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractImageJFlattener forCommandLine(String cmdline) {
        return (AbstractImageJFlattener)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }
}

