/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.data.imagej.Image;
import adams.data.imagej.transformer.AbstractImageJTransformer;

public class NamedSetup
extends AbstractImageJTransformer {
    private static final long serialVersionUID = 7793661256600883689L;
    protected adams.core.NamedSetup m_Setup;
    protected AbstractImageJTransformer m_ActualScheme;

    public String globalInfo() {
        return "Applies an ImageJ flattener that is referenced via its global setup name (see 'NamedSetups').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", (Object)new adams.core.NamedSetup());
    }

    public void reset() {
        super.reset();
        this.m_ActualScheme = null;
    }

    public void setSetup(adams.core.NamedSetup value) {
        this.m_Setup = value;
        if (!this.m_Setup.isDummy() && !this.m_Setup.exists()) {
            this.getSystemErr().println("Warning: named setup '" + this.m_Setup + "' unknown!");
        }
        this.reset();
    }

    public adams.core.NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The name of the setup to use.";
    }

    protected AbstractImageJTransformer getActualScheme() {
        if (this.m_ActualScheme == null) {
            this.m_ActualScheme = (AbstractImageJTransformer)this.m_Setup.getSetup();
            if (this.m_ActualScheme == null) {
                throw new IllegalStateException("Failed to instantiate named setup '" + this.m_Setup + "'!");
            }
        }
        return this.m_ActualScheme;
    }

    protected Image[] doTransform(Image img) {
        return this.getActualScheme().transform(img);
    }
}

