/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.data.imagej.Image;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import ij.ImagePlus;
import ij.process.ImageProcessor;

public class Resize
extends AbstractImageJTransformer {
    private static final long serialVersionUID = -7139209460998569352L;
    protected int m_Width;
    protected int m_Height;

    public String globalInfo() {
        return "Resizes the image to predefined width and height.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)-1, (Number)-1, null);
    }

    public void setWidth(int value) {
        if (value >= -1) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getSystemErr().println("Width must be -1 (current width) or greater, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width to resize the image to; use -1 to use original width.";
    }

    public void setHeight(int value) {
        if (value >= -1) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getSystemErr().println("Height must be -1 (current height) or greater, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height to resize the image to; use -1 to use original height.";
    }

    protected Image[] doTransform(Image img) {
        ImagePlus im = img.getImage();
        ImageProcessor ip = im.getProcessor();
        ip.setInterpolate(true);
        ImageProcessor ipNew = ip.resize(this.m_Width == -1 ? im.getWidth() : this.m_Width, this.m_Height == -1 ? im.getHeight() : this.m_Height);
        ImagePlus imNew = new ImagePlus(im.getTitle() + "-resized[w=" + this.m_Width + ",h=" + this.m_Height + "]", ipNew);
        return new Image[]{new Image(imNew, img.getMetaData())};
    }
}

