/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ImageMagickHelper;
import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;

public class ImageMagickReader
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 275040379368744L;

    public String globalInfo() {
        return "Reads any file format that ImageMagick can read.\nNB: Uses im4java, i.e., ImageMagick (http://www.imagemagick.org/) executables must be available on the PATH.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, URL.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImage.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !ImageMagickHelper.isConvertAvailable()) {
            result = "'convert' is not available on PATH!";
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        BufferedImage image = this.m_InputToken.getPayload() instanceof String ? ImageMagickHelper.read((File)new PlaceholderFile((String)this.m_InputToken.getPayload())) : (this.m_InputToken.getPayload() instanceof File ? ImageMagickHelper.read((File)this.m_InputToken.getPayload()) : ImageMagickHelper.read((URL)this.m_InputToken.getPayload()));
        if (image != null) {
            this.m_OutputToken = new Token((Object)image);
        } else {
            result = "Failed to read image from: " + this.m_InputToken.getPayload();
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.setProvenance(this.m_InputToken.getProvenance());
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

