/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pixelselector;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.transformer.pixelselector.AbstractSingleColorPixelSelectorOverlay;
import adams.flow.transformer.pixelselector.AddClassification;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Vector;

public class ClassificationOverlay
extends AbstractSingleColorPixelSelectorOverlay {
    private static final long serialVersionUID = 5524667354695674686L;

    @Override
    protected String getGlobalInfo() {
        return "Highlights the chosen classifications.";
    }

    @Override
    public Class[] getSuggestedActions() {
        return new Class[]{AddClassification.class};
    }

    protected Integer[] getClassificationIndices() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Vector fields = this.m_Image.getReport().getFields();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith("Classification.")) continue;
            result.add(Integer.parseInt(field.getName().substring("Classification.".length())));
        }
        return result.toArray(new Integer[result.size()]);
    }

    protected Point getPixelLocation(int index) {
        Report report;
        Point result = null;
        if (this.m_Image != null && this.m_Image.hasReport() && (report = this.m_Image.getReport()).hasValue("Pixel.X." + index) && report.hasValue("Pixel.Y." + index)) {
            result = new Point(report.getDoubleValue("Pixel.X." + index).intValue(), report.getDoubleValue("Pixel.Y." + index).intValue());
        }
        return result;
    }

    @Override
    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        Integer[] indices = this.getClassificationIndices();
        if (indices.length == 0) {
            return;
        }
        for (Integer index : indices) {
            Point loc = this.getPixelLocation(index);
            if (loc == null) continue;
            String label = this.m_Image.getReport().getStringValue("Classification." + index);
            g.setColor(this.m_Color);
            int x = (int)loc.getX();
            int y = (int)loc.getY();
            g.drawRect(x, y, 3, 3);
            if (label == null) continue;
            g.drawString(index + ":" + label, x + 5, y);
        }
    }
}

