/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.flattener;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class Histogram
extends AbstractImageJFlattener {
    private static final long serialVersionUID = -8349656592325229512L;
    protected HistogramType m_HistogramType;

    public String globalInfo() {
        return "Turns an image into a histogram.\nIn case of an 8-bit histogram, the image must already be converted to a gray image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("histo-type", "histogramType", (Object)HistogramType.RGB);
    }

    public void setHistogramType(HistogramType value) {
        this.m_HistogramType = value;
        this.reset();
    }

    public HistogramType getHistogramType() {
        return this.m_HistogramType;
    }

    public String histogramTypeTipText() {
        return "The type of histogram to generate.";
    }

    @Override
    public Instances createHeader(ImagePlusContainer img) {
        int numAtts = 256;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        block4: for (int i = 0; i < numAtts; ++i) {
            switch (this.m_HistogramType) {
                case EIGHT_BIT: {
                    atts.add(new Attribute("histo_" + (i + 1)));
                    continue block4;
                }
                case RGB: {
                    atts.add(new Attribute("histo_r_" + (i + 1)));
                    atts.add(new Attribute("histo_g_" + (i + 1)));
                    atts.add(new Attribute("histo_b_" + (i + 1)));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
                }
            }
        }
        Instances result = new Instances(this.getClass().getName(), atts, 0);
        return result;
    }

    @Override
    public Instance[] doFlatten(ImagePlusContainer img) {
        Instance[] result = null;
        double[] values = this.newArray(this.m_Header.numAttributes());
        ImagePlus ip = (ImagePlus)img.getImage();
        switch (this.m_HistogramType) {
            case EIGHT_BIT: {
                int[] pixels = ip.getProcessor().getHistogram();
                for (int i = 0; i < Array.getLength(pixels); ++i) {
                    values[i] = Array.getDouble(pixels, i);
                }
                break;
            }
            case RGB: {
                for (int n = 0; n < 3; ++n) {
                    ColorProcessor cp = new ColorProcessor(ip.getImage());
                    byte[] R = new byte[ip.getWidth() * ip.getHeight()];
                    byte[] G = new byte[ip.getWidth() * ip.getHeight()];
                    byte[] B = new byte[ip.getWidth() * ip.getHeight()];
                    cp.getRGB(R, G, B);
                    ByteProcessor bp = null;
                    if (n == 0) {
                        bp = new ByteProcessor(ip.getWidth(), ip.getHeight(), R, null);
                    } else if (n == 1) {
                        bp = new ByteProcessor(ip.getWidth(), ip.getHeight(), G, null);
                    } else if (n == 2) {
                        bp = new ByteProcessor(ip.getWidth(), ip.getHeight(), B, null);
                    }
                    int[] pixels = bp.getHistogram();
                    for (int i = 0; i < Array.getLength(pixels); ++i) {
                        values[i * 3 + n] = Array.getDouble(pixels, i);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
            }
        }
        result = new Instance[]{new DenseInstance(1.0, values)};
        result[0].setDataset(this.m_Header);
        return result;
    }

    public static enum HistogramType implements EnumWithCustomDisplay<HistogramType>
    {
        EIGHT_BIT("8-bit"),
        RGB("RGB");

        private String m_Display;
        private String m_Raw;

        private HistogramType(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        public String toDisplay() {
            return this.m_Display;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        public HistogramType parse(String s) {
            return HistogramType.valueOf((AbstractOption)null, s);
        }

        public static String toString(AbstractOption option, Object object) {
            return ((HistogramType)((Object)object)).toRaw();
        }

        public static HistogramType valueOf(AbstractOption option, String str) {
            HistogramType result = null;
            try {
                result = HistogramType.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (HistogramType dt : HistogramType.values()) {
                    if (!dt.toDisplay().equals(str)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

