/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pixelselector;

import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.image.AbstractImage;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;

public abstract class AbstractPixelSelectorOverlay
extends AbstractOptionHandler
implements ImageOverlay,
ShallowCopySupporter<AbstractPixelSelectorOverlay> {
    private static final long serialVersionUID = -3880315824020638532L;
    protected AbstractImage m_Image;

    public String globalInfo() {
        StringBuilder result = new StringBuilder(this.getGlobalInfo());
        Class[] actions = this.getSuggestedActions();
        if (actions.length > 0) {
            result.append("\n\nSome actions that generate data for this overlay:");
            for (Class action : actions) {
                result.append("\n");
                result.append(action.getName());
            }
        }
        return result.toString();
    }

    protected abstract String getGlobalInfo();

    public abstract Class[] getSuggestedActions();

    public void setImage(AbstractImage value) {
        this.m_Image = value;
        this.reset();
    }

    public AbstractImage getImage() {
        return this.m_Image;
    }

    protected abstract void doPaintOverlay(ImagePanel.PaintPanel var1, Graphics var2);

    public void paintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        if (this.m_Image == null) {
            return;
        }
        if (!this.m_Image.hasReport()) {
            return;
        }
        this.doPaintOverlay(panel, g);
    }

    public AbstractPixelSelectorOverlay shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractPixelSelectorOverlay shallowCopy(boolean expand) {
        return (AbstractPixelSelectorOverlay)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }
}

