/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pixelselector;

import adams.core.base.BaseString;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.transformer.pixelselector.AbstractPixelSelectorAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class AddClassification
extends AbstractPixelSelectorAction {
    private static final long serialVersionUID = 553796438710725814L;
    public static final String PIXEL_X = "Pixel.X.";
    public static final String PIXEL_Y = "Pixel.Y.";
    public static final String CLASSIFICATION = "Classification.";
    protected BaseString[] m_Labels;
    protected boolean m_RememberLastSelection;

    @Override
    public String globalInfo() {
        return "Allows the user to select a pixel location and add a corresponding classification for it.\nStores the location with prefix 'Pixel.X.' and 'Pixel.Y.' and the classification using 'Classification.' as prefix.";
    }

    @Override
    protected String getTitle() {
        return "Add classification";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
        this.m_OptionManager.add("remember-last-selection", "rememberLastSelection", (Object)false);
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to offer the user for classifying the pixel.";
    }

    public void setRememberLastSelection(boolean value) {
        this.m_RememberLastSelection = value;
        this.reset();
    }

    public boolean getRememberLastSelection() {
        return this.m_RememberLastSelection;
    }

    public String rememberLastSelectionTipText() {
        return "If enabled, the last selected label will get selected by default the next time this action is chosen.";
    }

    protected int getNextClassificationIndex(Report report) {
        int result = 0;
        while (report.hasField(CLASSIFICATION + ++result)) {
        }
        return result;
    }

    @Override
    protected boolean doProcessAction(ActionEvent e) {
        BaseString label = this.m_RememberLastSelection && this.getPanel().hasLastActionResult(((Object)((Object)this)).getClass()) ? (BaseString)this.getPanel().getLastActionResult(((Object)((Object)this)).getClass()) : this.m_Labels[0];
        label = (BaseString)JOptionPane.showInputDialog((Component)((Object)this.getPanel()), "Please select classification", this.getName(), 3, null, this.m_Labels, label);
        if (label == null) {
            return false;
        }
        if (this.m_RememberLastSelection) {
            this.getPanel().setLastActionResult(((Object)((Object)this)).getClass(), label);
        }
        Report report = this.getPanel().getImage().getReport();
        int index = this.getNextClassificationIndex(report);
        Field field = new Field(PIXEL_X + index, DataType.NUMERIC);
        report.addField((AbstractField)field);
        report.setValue((AbstractField)field, (Object)this.getPixelPosition().getX());
        field = new Field(PIXEL_Y + index, DataType.NUMERIC);
        report.addField((AbstractField)field);
        report.setValue((AbstractField)field, (Object)this.getPixelPosition().getY());
        field = new Field(CLASSIFICATION + index, DataType.STRING);
        report.addField((AbstractField)field);
        report.setValue((AbstractField)field, (Object)label.getValue());
        return true;
    }

    @Override
    public String check() {
        if (this.m_Labels.length < 1) {
            return "At least one label must be defined!";
        }
        return super.check();
    }
}

