/**
 * HistogramTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.data.imagej.flattener;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.data.imagej.flattener.Histogram.HistogramType;
import adams.env.Environment;

/**
 * Test class for the Histogram flattener. Run from the command line with: <p/>
 * java adams.data.imagej.flattener.HistogramTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class HistogramTest
  extends AbstractImageJFlattenerTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public HistogramTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"adams_icon.png",
	"adams_icon.pgm"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractImageJFlattener[] getRegressionSetups() {
    Histogram[]	result;

    result = new Histogram[2];

    result[0] = new Histogram();
    result[0].setHistogramType(HistogramType.RGB);

    result[1] = new Histogram();
    result[1].setHistogramType(HistogramType.EIGHT_BIT);

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(HistogramTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
