/**
 * RotateTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.jai.transformer;

import java.awt.Color;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for the Rotate transformer. Run from the command line with: <p/>
 * java adams.data.jai.transformer.RotateTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3979 $
 */
public class RotateTest
  extends AbstractJAITransformerTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public RotateTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"adams_icon.png",
	"adams_icon.png",
	"adams_icon.png"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractJAITransformer[] getRegressionSetups() {
    Rotate[]	result;

    result    = new Rotate[3];
    result[0] = new Rotate();
    result[1] = new Rotate();
    result[1].setAngle(355.0);
    result[2] = new Rotate();
    result[2].setAngle(355.0);
    result[2].setBackground(Color.WHITE);

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(RotateTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
