/*
 * Gray8.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.jai.transformer;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;

/**
 <!-- globalinfo-start -->
 * Transforms the image into an 8-bit gray image.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3704 $
 */
public class Gray8
  extends AbstractJAITransformer {

  /** for serialization. */
  private static final long serialVersionUID = 2959486760492196174L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Transforms the image into an 8-bit gray image.";
  }

  /**
   * Performs no transformation at all, just returns the input.
   *
   * @param img		the image to process (can be modified, since it is a copy)
   * @return		the copy of the image
   */
  protected BufferedImage[] doTransform(BufferedImage img) {
    BufferedImage[]	result;
    BufferedImageOp 	op;

    result     = new BufferedImage[1];
    op        = new ColorConvertOp(ColorSpace.getInstance(ColorSpace.CS_GRAY), null);
    result[0] = op.filter(img, null);

    return result;
  }
}
