/**
 * NamedSetupTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.jai.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for the NamedSetup flattener. Run from the command line with: <p/>
 * java adams.data.jai.flattener.NamedSetupTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3706 $
 */
public class NamedSetupTest
  extends AbstractJAITransformerTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public NamedSetupTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"adams_icon.png"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractJAITransformer[] getRegressionSetups() {
    NamedSetup[]	result;

    result = new NamedSetup[1];

    result[0] = new NamedSetup();
    result[0].setSetup(new adams.core.NamedSetup("jai_transformer_passthrough"));

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(NamedSetupTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
