/**
 * JAIHelper.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core;

import java.io.File;

import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

/**
 * Helper class for JAI operations.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3705 $
 */
public class JAIHelper {

  /**
   * Disables the "java.lang.NoClassDefFoundError: com/sun/medialib/mlib/Image"
   * exception.
   * <p/>
   * Taken from <a href="http://www.java.net/node/666373" target="_blank">here</a>
   */
  public static void disableMediaLib() {
    System.setProperty("com.sun.media.jai.disableMediaLib", "true");
  }

  /**
   * Loads the specified file.
   *
   * @param file	the file to load
   * @return		the image
   */
  public static RenderedOp read(File file) {
    return read(file.getAbsolutePath());
  }

  /**
   * Loads the specified file.
   *
   * @param file	the file to load
   * @return		the image
   */
  public static RenderedOp read(String file) {
    RenderedOp	result;

    result =  JAI.create("fileload", file);

    return result;
  }
}
