/*
 * Pixels.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.jai.flattener;

import java.awt.image.BufferedImage;
import java.util.ArrayList;

import adams.core.BufferedImageHelper;

import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

/**
 <!-- globalinfo-start -->
 * Gets all the pixels of the image.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-meta-numeric &lt;adams.core.base.BaseString&gt; [-meta-numeric ...] (property: metaDataNumeric)
 * &nbsp;&nbsp;&nbsp;The keys of the meta-data properties that will be converted to numeric attributes.
 * &nbsp;&nbsp;&nbsp;default:
 * </pre>
 *
 * <pre>-meta-string &lt;adams.core.base.BaseString&gt; [-meta-string ...] (property: metaDataString)
 * &nbsp;&nbsp;&nbsp;The keys of the meta-data properties that will be converted to string attributes.
 * &nbsp;&nbsp;&nbsp;default:
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @author  Dale (dale at cs dot waikato dot ac dot nz)
 * @version $Revision: 3702 $
 */
public class Pixels
  extends AbstractJAIFlattener {

  /** for serialization. */
  private static final long serialVersionUID = -8349656592325229512L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Gets all the pixels of the image.";
  }

  /**
   * Creates the header from a template image.
   *
   * @param img		the image to act as a template
   * @return		the generated header
   */
  protected Instances createHeader(BufferedImage img) {
    Instances			result;
    ArrayList<Attribute>	atts;
    int				i;
    int				numPixels;

    numPixels = img.getWidth() * img.getHeight();
    atts      = new ArrayList<Attribute>();
    for (i = 0; i < numPixels; i++)
      atts.add(new Attribute("att_" + (i+1)));
    result = new Instances(getClass().getName(), atts, 0);

    return result;
  }

  /**
   * Performs the actual flattening of the image.
   *
   * @param img		the image to process
   * @return		the generated array
   */
  protected Instance doFlatten(BufferedImage img) {
    Instance	result;
    double[]	values;
    int[]	pixels;
    int		i;

    result = null;
    pixels = BufferedImageHelper.getPixels(img);
    values = new double[m_Header.numAttributes()];
    for (i = 0; i < pixels.length; i++)
      values[i] = pixels[i];

    result = new DenseInstance(1.0, values);
    result.setDataset(m_Header);

    return result;
  }
}
