/**
 * JsonConsumerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import java.util.Arrays;
import java.util.Vector;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.JsonConsumer;
import adams.flow.core.AbstractActor;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/**
 * Tests the JsonConsumer class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2870 $
 */
public class JsonConsumerTest
  extends AbstractOptionConsumerTestCase<JSONObject> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public JsonConsumerTest(String name) {
    super(name);
  }

  /**
   * Tests a simple option handler.
   */
  public void testConsumeSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
    handler.setAppend(true);

    JSONObject input = new JSONObject();
    input.put(JsonConsumer.KEY_CLASS, "adams.flow.sink.DumpFile");
    input.put("debugLevel", 1);
    input.put("outputFile", "${TMP}/dumpfile.csv");
    input.put("append", true);

    performInputTest(new JsonConsumer(), input, handler);
  }

  /**
   * Tests generating a simple option handler from a string.
   */
  public void testFromStringSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
    handler.setAppend(true);

    JSONObject input = new JSONObject();
    input.put(JsonConsumer.KEY_CLASS, "adams.flow.sink.DumpFile");
    input.put("debugLevel", 1);
    input.put("outputFile", "${TMP}/dumpfile.csv");
    input.put("append", true);

    performFromStringTest(
	JsonConsumer.class,
	input.toJSONString(),
	handler);
  }

  /**
   * Tests a deeply nested option handler.
   */
  public void testConsumeDeep() {
    adams.data.filter.MultiFilter handler = new adams.data.filter.MultiFilter();
    handler.setDebugLevel(1);
    adams.data.filter.AbstractFilter[] filters = new adams.data.filter.AbstractFilter[2];
    filters[0] = new adams.data.filter.PassThrough();
    filters[0].setDebugLevel(2);
    filters[1] = new adams.data.filter.MultiFilter();
    filters[1].setDebugLevel(3);
    handler.setSubFilters(filters);

    JSONObject input = new JSONObject();
    input.put(JsonConsumer.KEY_CLASS, "adams.data.filter.MultiFilter");
    JSONArray options = new JSONArray();
    input.put("subFilters", options);
    input.put("debugLevel", 1);

    JSONObject filter1 = new JSONObject();
    options.add(filter1);
    filter1.put(JsonConsumer.KEY_CLASS, "adams.data.filter.PassThrough");
    filter1.put("debugLevel", 2);

    JSONObject filter2 = new JSONObject();
    options.add(filter2);
    filter2.put(JsonConsumer.KEY_CLASS, "adams.data.filter.MultiFilter");
    filter2.put("debugLevel", 3);
    JSONArray options2 = new JSONArray();
    filter2.put("subFilters", options2);
    JSONObject filter3 = new JSONObject();
    options2.add(filter3);
    filter3.put(JsonConsumer.KEY_CLASS, "adams.data.filter.PassThrough");

    performInputTest(new JsonConsumer(), input, handler);
  }

  /**
   * Tests generating a deeply nested option handler from a string.
   */
  public void testFromStringDeep() {
    adams.data.filter.MultiFilter handler = new adams.data.filter.MultiFilter();
    handler.setDebugLevel(1);
    adams.data.filter.AbstractFilter[] filters = new adams.data.filter.AbstractFilter[2];
    filters[0] = new adams.data.filter.PassThrough();
    filters[0].setDebugLevel(2);
    filters[1] = new adams.data.filter.MultiFilter();
    filters[1].setDebugLevel(3);
    handler.setSubFilters(filters);

    JSONObject input = new JSONObject();
    input.put(JsonConsumer.KEY_CLASS, "adams.data.filter.MultiFilter");
    JSONArray options = new JSONArray();
    input.put("subFilters", options);
    input.put("debugLevel", 1);

    JSONObject filter1 = new JSONObject();
    options.add(filter1);
    filter1.put(JsonConsumer.KEY_CLASS, "adams.data.filter.PassThrough");
    filter1.put("debugLevel", 2);

    JSONObject filter2 = new JSONObject();
    options.add(filter2);
    filter2.put(JsonConsumer.KEY_CLASS, "adams.data.filter.MultiFilter");
    filter2.put("debugLevel", 3);
    JSONArray options2 = new JSONArray();
    filter2.put("subFilters", options2);
    JSONObject filter3 = new JSONObject();
    options2.add(filter3);
    filter3.put(JsonConsumer.KEY_CLASS, "adams.data.filter.PassThrough");

    performFromStringTest(
	JsonConsumer.class,
	input.toJSONString(),
	handler);
  }

  /**
   * Tests another deeply nested option handler.
   */
  public void testConsumeDeep2() {
    adams.data.filter.BaselineCorrection handler = new adams.data.filter.BaselineCorrection();
    adams.data.baseline.SlidingWindow baselineObj = new adams.data.baseline.SlidingWindow();
    baselineObj.setDebugLevel(2);
    handler.setBaselineCorrection(baselineObj);

    JSONObject input = new JSONObject();
    input.put(JsonConsumer.KEY_CLASS, "adams.data.filter.BaselineCorrection");
    JSONObject input2 = new JSONObject();
    input.put("baselineCorrection", input2);
    input2.put(JsonConsumer.KEY_CLASS, "adams.data.baseline.SlidingWindow");
    input2.put("debugLevel", 2);
    JSONObject input3 = new JSONObject();
    input2.put("baselineCorrection", input3);
    input3.put(JsonConsumer.KEY_CLASS, "adams.data.baseline.PassThrough");

    performInputTest(new JsonConsumer(), input, handler);
  }

  /**
   * Tests generating another deeply nested option handler from a string.
   */
  public void testFromStringDeep2() {
    adams.data.filter.BaselineCorrection handler = new adams.data.filter.BaselineCorrection();
    adams.data.baseline.SlidingWindow baseline = new adams.data.baseline.SlidingWindow();
    baseline.setDebugLevel(2);
    handler.setBaselineCorrection(baseline);

    JSONObject input = new JSONObject();
    input.put(JsonConsumer.KEY_CLASS, "adams.data.filter.BaselineCorrection");
    JSONObject input2 = new JSONObject();
    input.put("baselineCorrection", input2);
    input2.put(JsonConsumer.KEY_CLASS, "adams.data.baseline.SlidingWindow");
    input2.put("debugLevel", 2);
    JSONObject input3 = new JSONObject();
    input2.put("baselineCorrection", input3);
    input3.put(JsonConsumer.KEY_CLASS, "adams.data.baseline.PassThrough");

    performFromStringTest(
	JsonConsumer.class,
	input.toJSONString(),
	handler);
  }

  /**
   * Tests generating another deeply nested option handler from a string.
   */
  public void testFromStringDeep3() {
    adams.flow.control.Flow handler = new adams.flow.control.Flow();
    adams.flow.source.StringConstants sc = new adams.flow.source.StringConstants();
    sc.setStrings(new BaseString[]{
	new BaseString("1"),
	new BaseString("2"),
	new BaseString("3")
    });
    adams.data.conversion.StringToDouble s2d = new adams.data.conversion.StringToDouble();
    adams.flow.transformer.Convert con = new adams.flow.transformer.Convert();
    con.setConversion(s2d);
    adams.flow.transformer.MathExpression me = new adams.flow.transformer.MathExpression();
    me.setExpression("X^2");
    adams.flow.sink.DumpFile df = new adams.flow.sink.DumpFile();
    df.setAppend(true);
    df.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.txt"));
    handler.setActors(new AbstractActor[]{
	sc,
	con,
	me,
	df
    });

    JSONObject input = new JSONObject();
    input.put(JsonConsumer.KEY_CLASS, "adams.flow.control.Flow");
    JSONArray actors = new JSONArray();
    input.put("actors", actors);

    JSONObject input2 = new JSONObject();
    actors.add(input2);
    input2.put(JsonConsumer.KEY_CLASS, "adams.flow.source.StringConstants");
    JSONArray strings = new JSONArray();
    strings.add("1");
    strings.add("2");
    strings.add("3");
    input2.put("strings", strings);

    JSONObject input3 = new JSONObject();
    actors.add(input3);
    input3.put(JsonConsumer.KEY_CLASS, "adams.flow.transformer.Convert");
    JSONObject input4 = new JSONObject();
    input4.put(JsonConsumer.KEY_CLASS, "adams.data.conversion.StringToDouble");
    input3.put("conversion", input4);

    JSONObject input5 = new JSONObject();
    actors.add(input5);
    input5.put(JsonConsumer.KEY_CLASS, "adams.flow.transformer.MathExpression");
    input5.put("expression", "X^2");

    JSONObject input6 = new JSONObject();
    actors.add(input6);
    input6.put(JsonConsumer.KEY_CLASS, "adams.flow.sink.DumpFile");
    input6.put("append", true);
    input6.put("outputFile", "${TMP}/dumpfile.txt");

    performFromStringTest(
	JsonConsumer.class,
	input.toJSONString(),
	handler);
  }
}
