/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionProducerTestCase;
import adams.core.option.JsonProducer;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.filter.AbstractFilter;
import adams.data.filter.BaselineCorrection;
import adams.data.filter.MultiFilter;
import adams.data.filter.PassThrough;
import adams.flow.sink.DumpFile;

public class JsonProducerTest
extends AbstractOptionProducerTestCase {
    public JsonProducerTest(String name) {
        super(name);
    }

    public void testSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.arff"));
        handler.setAppend(true);
        JsonProducer producer = new JsonProducer();
        producer.produce((OptionHandler)handler);
        JsonProducerTest.assertEquals((String)"getOutput() differs", (String)"{\"append\":true,\"outputFile\":\"${TMP}\\/dumpfile.arff\",\"name\":\"DumpFile\",\"debugLevel\":1,\"class\":\"adams.flow.sink.DumpFile\",\"annotations\":\"\",\"skip\":false,\"stopFlowOnError\":false}", (String)("" + producer.getOutput()));
        JsonProducerTest.assertEquals((String)"toString() differs", (String)"{\"append\":true,\"outputFile\":\"${TMP}\\/dumpfile.arff\",\"name\":\"DumpFile\",\"debugLevel\":1,\"class\":\"adams.flow.sink.DumpFile\",\"annotations\":\"\",\"skip\":false,\"stopFlowOnError\":false}", (String)producer.toString());
    }

    public void testDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        JsonProducer producer = new JsonProducer();
        producer.produce((OptionHandler)handler);
        JsonProducerTest.assertEquals((String)"getOutput() differs", (String)"{\"debugLevel\":1,\"subFilters\":[{\"debugLevel\":2,\"class\":\"adams.data.filter.PassThrough\"},{\"debugLevel\":3,\"subFilters\":[{\"debugLevel\":0,\"class\":\"adams.data.filter.PassThrough\"}],\"class\":\"adams.data.filter.MultiFilter\"}],\"class\":\"adams.data.filter.MultiFilter\"}", (String)("" + producer.getOutput()));
        JsonProducerTest.assertEquals((String)"toString() differs", (String)"{\"debugLevel\":1,\"subFilters\":[{\"debugLevel\":2,\"class\":\"adams.data.filter.PassThrough\"},{\"debugLevel\":3,\"subFilters\":[{\"debugLevel\":0,\"class\":\"adams.data.filter.PassThrough\"}],\"class\":\"adams.data.filter.MultiFilter\"}],\"class\":\"adams.data.filter.MultiFilter\"}", (String)producer.toString());
    }

    public void testDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        JsonProducer producer = new JsonProducer();
        producer.produce((OptionHandler)handler);
        JsonProducerTest.assertEquals((String)"getOutput() differs", (String)"{\"baselineCorrection\":{\"baselineCorrection\":{\"debugLevel\":0,\"class\":\"adams.data.baseline.PassThrough\"},\"debugLevel\":2,\"numRight\":30,\"class\":\"adams.data.baseline.SlidingWindow\",\"numLeft\":30},\"debugLevel\":0,\"class\":\"adams.data.filter.BaselineCorrection\"}", (String)("" + producer.getOutput()));
        JsonProducerTest.assertEquals((String)"toString() differs", (String)"{\"baselineCorrection\":{\"baselineCorrection\":{\"debugLevel\":0,\"class\":\"adams.data.baseline.PassThrough\"},\"debugLevel\":2,\"numRight\":30,\"class\":\"adams.data.baseline.SlidingWindow\",\"numLeft\":30},\"debugLevel\":0,\"class\":\"adams.data.filter.BaselineCorrection\"}", (String)producer.toString());
    }
}

