/**
 * JsonProducerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.option.JsonProducer;

/**
 * Tests the JsonProducer class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2870 $
 */
public class JsonProducerTest
  extends AbstractOptionProducerTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public JsonProducerTest(String name) {
    super(name);
  }

  /**
   * Tests a simple option handler.
   */
  public void testSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.arff"));
    handler.setAppend(true);

    JsonProducer producer = new JsonProducer();
    producer.produce(handler);

    assertEquals(
	"getOutput() differs",
	"{\"append\":true,\"outputFile\":\"${TMP}\\/dumpfile.arff\",\"name\":\"DumpFile\",\"debugLevel\":1,\"class\":\"adams.flow.sink.DumpFile\",\"annotations\":\"\",\"skip\":false,\"stopFlowOnError\":false}",
	"" + producer.getOutput());
    assertEquals(
	"toString() differs",
	"{\"append\":true,\"outputFile\":\"${TMP}\\/dumpfile.arff\",\"name\":\"DumpFile\",\"debugLevel\":1,\"class\":\"adams.flow.sink.DumpFile\",\"annotations\":\"\",\"skip\":false,\"stopFlowOnError\":false}",
	producer.toString());
  }

  /**
   * Tests a deeply nested option handler.
   */
  public void testDeep() {
    adams.data.filter.MultiFilter handler = new adams.data.filter.MultiFilter();
    handler.setDebugLevel(1);
    adams.data.filter.AbstractFilter[] filters = new adams.data.filter.AbstractFilter[2];
    filters[0] = new adams.data.filter.PassThrough();
    filters[0].setDebugLevel(2);
    filters[1] = new adams.data.filter.MultiFilter();
    filters[1].setDebugLevel(3);
    handler.setSubFilters(filters);

    JsonProducer producer = new JsonProducer();
    producer.produce(handler);

    assertEquals(
	"getOutput() differs",
	"{\"debugLevel\":1,\"subFilters\":[{\"debugLevel\":2,\"class\":\"adams.data.filter.PassThrough\"},{\"debugLevel\":3,\"subFilters\":[{\"debugLevel\":0,\"class\":\"adams.data.filter.PassThrough\"}],\"class\":\"adams.data.filter.MultiFilter\"}],\"class\":\"adams.data.filter.MultiFilter\"}",
	"" + producer.getOutput());
    assertEquals(
	"toString() differs",
	"{\"debugLevel\":1,\"subFilters\":[{\"debugLevel\":2,\"class\":\"adams.data.filter.PassThrough\"},{\"debugLevel\":3,\"subFilters\":[{\"debugLevel\":0,\"class\":\"adams.data.filter.PassThrough\"}],\"class\":\"adams.data.filter.MultiFilter\"}],\"class\":\"adams.data.filter.MultiFilter\"}",
	producer.toString());
  }

  /**
   * Tests another deeply nested option handler.
   */
  public void testDeep2() {
    adams.data.filter.BaselineCorrection handler = new adams.data.filter.BaselineCorrection();
    adams.data.baseline.SlidingWindow baseline = new adams.data.baseline.SlidingWindow();
    baseline.setDebugLevel(2);
    handler.setBaselineCorrection(baseline);

    JsonProducer producer = new JsonProducer();
    producer.produce(handler);

    assertEquals(
	"getOutput() differs",
	"{\"baselineCorrection\":{\"baselineCorrection\":{\"debugLevel\":0,\"class\":\"adams.data.baseline.PassThrough\"},\"debugLevel\":2,\"numRight\":30,\"class\":\"adams.data.baseline.SlidingWindow\",\"numLeft\":30},\"debugLevel\":0,\"class\":\"adams.data.filter.BaselineCorrection\"}",
	"" + producer.getOutput());
    assertEquals(
	"toString() differs",
	"{\"baselineCorrection\":{\"baselineCorrection\":{\"debugLevel\":0,\"class\":\"adams.data.baseline.PassThrough\"},\"debugLevel\":2,\"numRight\":30,\"class\":\"adams.data.baseline.SlidingWindow\",\"numLeft\":30},\"debugLevel\":0,\"class\":\"adams.data.filter.BaselineCorrection\"}",
	producer.toString());
  }
}
