/*
 * JythonScript.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.core.scripting;

import adams.gui.core.AbstractScript;
import adams.gui.core.AbstractTextEditorPanelWithSyntaxHighlighting;
import adams.gui.core.JythonSyntaxEditorPanel;

/**
 * Wrapper for a Jython scripts to be editable in the GOE.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3814 $
 */
public class JythonScript
  extends AbstractScript {

  /** for serialization. */
  private static final long serialVersionUID = 4309078655122480376L;

  /**
   * Initializes the string with length 0.
   */
  public JythonScript() {
    this("");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public JythonScript(String s) {
    super(s);
  }

  /**
   * Returns the tip text for the script.
   *
   * @return		the tool tip
   */
  protected String getScriptTipText() {
    return "Jython script";
  }

  /**
   * Returns the configured text editor panel to use in the GOE.
   *
   * @return		the text editor panel
   */
  public AbstractTextEditorPanelWithSyntaxHighlighting getTextEditorPanel() {
    return new JythonSyntaxEditorPanel();
  }
}
