/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * BaseData.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.ml;

/**
 * 
 *
 * @author  dale (dale at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class BaseData {

  protected Object m_data;
  public enum Type{
    NUMERIC,
    STRING,
    BOOLEAN,
    ARRAY
  }

  public static boolean isNumeric(Object o){
    if(o instanceof Number){
      return(true);
    }
    if (o instanceof String){
      try{
	Double.parseDouble((String)o);
	return(true);
      }catch(Exception e){
      }
    }
    return(false);
  }
  public static boolean isString(Object o){
    return(o instanceof String);
  }
  public static boolean isArray(Object o){
    return(o.getClass().isArray());
  }
  public static boolean isBoolean(Object o){
    return(o instanceof Boolean);
  }

  public BaseData(Object o){
    m_data=o;
  }
  public Object getData(){
    return(m_data);
  }
  public void setData(Object data){
    m_data=data;
  }
  public Object getData(Type type){
    return(m_data);
  }
  public void setData(Object data, Type type){
    m_data=data;
  }

  public static BaseData.Type getType(Object data){
    if (isNumeric(data)){
      return(BaseData.Type.NUMERIC);
    }
    if (isArray(data)){
      return(BaseData.Type.ARRAY);
    }
    if (isBoolean(data)){
      return(BaseData.Type.BOOLEAN);
    }
    if (isString(data)){
      return(BaseData.Type.STRING);
    }
    return(null);
  }
  public static boolean typeEquals(Object data, BaseData.Type typ){
    BaseData.Type nt=getType(data);
    int o1=nt.ordinal();
    int o2=typ.ordinal();
    return(o1==o2);
  }
  public boolean isNumeric(){
    return (isNumeric(m_data));
  }
  public boolean isArray(){
    return (isArray(m_data));
  }
  public boolean isString(){
    return (isString(m_data));
  }
}
