/*
 * MOAClustererEvaluationTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import moa.evaluation.BasicClassificationPerformanceEvaluator;
import moa.evaluation.BasicClusteringPerformanceEvaluator;
import moa.options.ClassOption;
import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.standalone.GlobalActors;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.MOAClusterer;
import adams.flow.transformer.MOAClustererEvaluation;
import adams.flow.transformer.MOALearningEvaluation;
import adams.test.TmpFile;

/**
 * Tests the MOAClustererEvaluation actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2909 $
 */
public class MOAClustererEvaluationTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public MOAClustererEvaluationTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("iris.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("iris.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    ClassOption option = new ClassOption(
	"clusterer",
	'c',
	"The MOA clusterer to use from within ADAMS.",
	moa.clusterers.Clusterer.class,
	"CobWeb",
	"moa.clusterers.CobWeb");

    MOAClusterer cls = new MOAClusterer();
    cls.setClusterer(option);
    cls.setName("clusterer");

    GlobalActors ga = new GlobalActors();
    ga.setActors(new AbstractActor[]{cls});

    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("iris.arff"));

    WekaFileReader fr = new WekaFileReader();
    fr.setIncremental(true);

    option = new ClassOption(
	"evaluator",
	'e',
	"The MOA clusterer performance evaluator to use from within ADAMS.",
	moa.evaluation.LearningPerformanceEvaluator.class,
	"BasicClusteringPerformanceEvaluator",
	BasicClusteringPerformanceEvaluator.class.getName());

    MOAClustererEvaluation mce = new MOAClustererEvaluation();
    mce.setClusterer(new GlobalActorReference("clusterer"));
    mce.setEvaluator(option);
    mce.setOutputInterval(50);   // 150 instances in the dataset

    MOALearningEvaluation mle = new MOALearningEvaluation();

    DumpFile df = new DumpFile();
    df.setAppend(true);
    df.setOutputFile(new TmpFile("dumpfile.txt"));

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{ga, sfs, fr, mce, mle, df});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new TmpFile("dumpfile.txt"));
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(MOAClustererEvaluationTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
