/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.MOAClassifying;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaInstanceDumper;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MOAClassifyingTest
extends AbstractFlowTest {
    public MOAClassifyingTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.copyResourceToTmp("naivebayes.model");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("naivebayes.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("iris.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setIncremental(true);
        WekaClassSelector cs = new WekaClassSelector();
        MOAClassifying cls = new MOAClassifying();
        cls.setOutputInstance(true);
        cls.setModelFile((PlaceholderFile)new TmpFile("naivebayes.model"));
        WekaInstanceDumper id = new WekaInstanceDumper();
        id.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, cs, cls, id});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(MOAClassifyingTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAClassifyingTest.runTest((Test)MOAClassifyingTest.suite());
    }
}

