/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.MOAStream;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.options.ClassOption;
import moa.streams.InstanceStream;

public class MOAStreamTest
extends AbstractFlowTest {
    public MOAStreamTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        ClassOption cls = new ClassOption("stream", 's', "The MOA stream generator to use from within ADAMS.", InstanceStream.class, "generators.AgrawalGenerator", "moa.streams.generators.AgrawalGenerator");
        MOAStream ms = new MOAStream();
        ms.setStreamGenerator(cls);
        ms.setNumExamples(20);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.arff"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ms, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(MOAStreamTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAStreamTest.runTest((Test)MOAStreamTest.suite());
    }
}

