/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.MOAClassifier;
import adams.flow.transformer.MOAClassifierEvaluation;
import adams.flow.transformer.MOALearningEvaluation;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.classifiers.Classifier;
import moa.evaluation.BasicClassificationPerformanceEvaluator;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.options.ClassOption;

public class MOAClassifierEvaluationTest
extends AbstractFlowTest {
    public MOAClassifierEvaluationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        ClassOption option = new ClassOption("classifier", 'c', "The MOA classifier to use from within ADAMS.", Classifier.class, "DecisionStump", "moa.classifiers.DecisionStump");
        MOAClassifier cls = new MOAClassifier();
        cls.setClassifier(option);
        cls.setName("classifier");
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{cls});
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("iris.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setIncremental(true);
        WekaClassSelector cs = new WekaClassSelector();
        option = new ClassOption("evaluator", 'e', "The MOA classifier performance evaluator to use from within ADAMS.", ClassificationPerformanceEvaluator.class, "BasicClassificationPerformanceEvaluator", BasicClassificationPerformanceEvaluator.class.getName());
        MOAClassifierEvaluation mce = new MOAClassifierEvaluation();
        mce.setClassifier(new GlobalActorReference("classifier"));
        mce.setEvaluator(option);
        mce.setOutputInterval(50);
        MOALearningEvaluation mle = new MOALearningEvaluation();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, mce, mle, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(MOAClassifierEvaluationTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAClassifierEvaluationTest.runTest((Test)MOAClassifierEvaluationTest.suite());
    }
}

