/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MOAHelper;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.GlobalSource;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import moa.classifiers.AbstractClassifier;
import moa.core.Measurement;
import moa.evaluation.BasicClassificationPerformanceEvaluator;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.options.ClassOption;
import weka.core.Instance;
import weka.core.MOAUtils;
import weka.core.Utils;

public class MOAClassifierEvaluation
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 1410487605033307517L;
    public static final String BACKUP_CLASSIFIER = "classifier";
    protected GlobalActorReference m_Classifier;
    protected AbstractClassifier m_ActualClassifier;
    protected ClassOption m_Evaluator;
    protected ClassificationPerformanceEvaluator m_ActualEvaluator;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Evaluates a MOA classifier using prequential evaluation. With each incoming instance, the classifier is first evaluated, then trained.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_CLASSIFIER, BACKUP_CLASSIFIER, (Object)new GlobalActorReference("MOAClassifier"));
        this.m_OptionManager.add("evaluator", "evaluator", (Object)this.getDefaultOption());
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualEvaluator = null;
        this.m_Count = 0;
        this.m_ActualClassifier = null;
    }

    public void setClassifier(GlobalActorReference value) {
        this.m_Classifier = value;
        this.reset();
    }

    public GlobalActorReference getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The name of the global MOA classifier to train/evaluate.";
    }

    protected ClassificationPerformanceEvaluator getDefaultEvaluator() {
        return new BasicClassificationPerformanceEvaluator();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("evaluator", 'e', "The MOA classifier performance evaluator to use from within ADAMS.", ClassificationPerformanceEvaluator.class, this.getDefaultEvaluator().getClass().getName().replace("moa.evaluation.", ""), this.getDefaultEvaluator().getClass().getName());
    }

    public void setEvaluator(ClassOption value) {
        this.m_Evaluator = (ClassOption)value.copy();
        this.reset();
    }

    public ClassOption getEvaluator() {
        return this.m_Evaluator;
    }

    public String evaluatorTipText() {
        return "The MOA evaluator to use for evaluating a trained MOA classifier.";
    }

    protected ClassificationPerformanceEvaluator getCurrentEvaluator() {
        return (ClassificationPerformanceEvaluator)MOAUtils.fromOption((ClassOption)this.m_Evaluator);
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to skip before evaluating the classifier stored in the token.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty(BACKUP_CLASSIFIER);
        String result = variable != null ? variable : this.m_Classifier.toString();
        variable = this.getOptionManager().getVariableForProperty("evaluator");
        result = variable != null ? result + ", " + variable : result + ", " + this.getCurrentEvaluator().getClass().getName().replace("moa.evaluation.", "");
        variable = this.getOptionManager().getVariableForProperty("outputInterval");
        result = variable != null ? result + "/" + variable : result + "/" + (this.m_OutputInterval == 1 ? "always" : Integer.valueOf(this.m_OutputInterval));
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public Class[] generates() {
        return new Class[]{Measurement[].class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CLASSIFIER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualClassifier != null) {
            result.put(BACKUP_CLASSIFIER, this.m_ActualClassifier);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CLASSIFIER)) {
            this.m_ActualClassifier = (AbstractClassifier)state.get(BACKUP_CLASSIFIER);
            state.remove(BACKUP_CLASSIFIER);
        }
        super.restoreState(state);
    }

    protected AbstractClassifier getClassifierInstance() {
        AbstractClassifier result = null;
        GlobalSource global = new GlobalSource();
        global.setGlobalName(this.m_Classifier);
        global.setParent(this.getParent());
        if (global.setUp() == null) {
            global.execute();
            result = (AbstractClassifier)global.output().getPayload();
            AbstractActor actor = global.getGlobalActor();
            global.wrapUp();
            global.cleanUp();
            if (actor != null) {
                actor.setUp();
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_ActualEvaluator == null) {
            this.m_ActualEvaluator = this.getCurrentEvaluator();
        }
        Instance inst = (Instance)this.m_InputToken.getPayload();
        if (this.m_ActualClassifier == null) {
            this.m_ActualClassifier = this.getClassifierInstance();
            if (this.m_ActualClassifier == null) {
                result = "Failed to located classifier '" + this.m_Classifier + "'!";
                return result;
            }
        }
        Instance testInst = (Instance)inst.copy();
        int trueClass = (int)testInst.classValue();
        testInst.setClassMissing();
        double[] prediction = MOAHelper.fixVotes(this.m_ActualClassifier.getVotesForInstance(testInst), testInst);
        if (this.isDebugOn()) {
            this.debug("trueClass=" + trueClass + ", prediction=" + Utils.arrayToString((Object)prediction) + ", weight=" + testInst.weight());
        }
        this.m_ActualEvaluator.addResult(inst, prediction);
        this.m_ActualClassifier.trainOnInstance(inst);
        ++this.m_Count;
        if (this.m_Count % this.m_OutputInterval == 0) {
            this.m_Count = 0;
            this.m_OutputToken = new Token((Object)this.m_ActualEvaluator.getPerformanceMeasurements());
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.setProvenance(this.m_InputToken.getProvenance());
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualEvaluator = null;
        this.m_ActualClassifier = null;
    }
}

